/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.market.integration.jei;

import com.benbenlaw.market.block.ModBlocks;
import com.benbenlaw.market.integration.jei.MarketRecipeCategory;
import com.benbenlaw.market.recipe.MarketRecipe;
import com.benbenlaw.market.recipe.ModRecipes;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIMarketPlugin
implements IModPlugin {
    public static IDrawableStatic slotDrawable;
    public static RecipeType<MarketRecipe> MARKET_RECIPE;

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"market", (String)"jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MARKET.get()), new RecipeType[]{MarketRecipeCategory.RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new MarketRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        slotDrawable = guiHelper.getSlotDrawable();
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        registration.addRecipes(MarketRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.MARKET_TYPE.get()).stream().map(RecipeHolder::value).toList());
    }

    static {
        MARKET_RECIPE = new RecipeType(MarketRecipeCategory.UID, MarketRecipe.class);
    }
}

