/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.market.block;

import com.benbenlaw.market.block.ModBlockEntities;
import com.benbenlaw.market.config.ModConfig;
import com.benbenlaw.market.recipe.MarketRecipe;
import com.benbenlaw.market.screen.MarketMenu;
import com.benbenlaw.market.utils.ModTags;
import com.benbenlaw.opolisutilities.block.entity.custom.handler.InputOutputItemHandler;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarketBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(13){

        protected void onContentsChanged(int slot) {
            MarketBlockEntity.this.setChanged();
            MarketBlockEntity.this.sync();
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == MarketBlockEntity.this.LICENCE_SLOT) {
                return 1;
            }
            return super.getStackLimit(slot, stack);
        }
    };
    private FakePlayer fakePlayer;
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress = 220;
    public RecipeHolder<MarketRecipe> currentRecipe;
    public ResourceLocation recipeID = ResourceLocation.parse((String)"market:null");
    public int orderVariation;
    public boolean needNewRecipe = true;
    public int ticksSinceLastDamage;
    public int[] previousOrders = ArrayUtils.remove((int[])new int[1], (int)0);
    public double demand = 1.0;
    public boolean useNBT = false;
    public int LICENCE_SLOT = 0;
    private final IItemHandler marketItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> {
        if (i >= 10 && i <= 12) {
            return false;
        }
        if (i >= 1 && i <= 9) {
            Item itemToInsert = stack.getItem();
            for (int slot = 1; slot <= 9; ++slot) {
                ItemStack existingStack = this.itemHandler.getStackInSlot(slot);
                if (itemToInsert.asItem().getDefaultInstance().is(ModTags.LICENSES)) {
                    return false;
                }
                if (existingStack.isEmpty() || existingStack.getItem() != itemToInsert) continue;
                if (i == slot) {
                    int maxStackSize = existingStack.getMaxStackSize();
                    int currentStackSize = existingStack.getCount();
                    int availableSpace = maxStackSize - currentStackSize;
                    return stack.getCount() <= availableSpace;
                }
                return false;
            }
            if (this.itemHandler.getStackInSlot(i.intValue()).isEmpty()) {
                int maxStackSize = stack.getMaxStackSize();
                return stack.getCount() <= maxStackSize;
            }
            return false;
        }
        if (i == 0) {
            return stack.getItem().asItem().getDefaultInstance().is(ModTags.LICENSES);
        }
        return false;
    }, i -> i >= 10 && i <= 12);

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.marketItemHandler;
    }

    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public MarketBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MARKET_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> MarketBlockEntity.this.progress;
                    case 1 -> MarketBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        MarketBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        MarketBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.market.market");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new MarketMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        if (this.recipeID != null) {
            compoundTag.putString("recipeID", this.recipeID.toString());
        } else {
            compoundTag.putString("recipeID", "null");
        }
        compoundTag.putInt("orderVariation", this.orderVariation);
        compoundTag.putInt("ticksSinceLastDamage", this.ticksSinceLastDamage);
        compoundTag.putIntArray("previousOrders", this.previousOrders);
        compoundTag.putDouble("demand", this.demand);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.recipeID = compoundTag.getString("recipeID").equals("null") ? null : ResourceLocation.parse((String)compoundTag.getString("recipeID"));
        this.orderVariation = compoundTag.getInt("orderVariation");
        this.ticksSinceLastDamage = compoundTag.getInt("ticksSinceLastDamage");
        this.previousOrders = compoundTag.getIntArray("previousOrders");
        this.demand = compoundTag.getDouble("demand");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            int inputAmount;
            Optional recipe;
            Level level;
            this.sync();
            if (this.fakePlayer == null && (level = this.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.fakePlayer = this.createFakePlayer(serverLevel);
            }
            RecipeInput inventory = new RecipeInput(){

                @NotNull
                public ItemStack getItem(int index) {
                    return MarketBlockEntity.this.itemHandler.getStackInSlot(index);
                }

                public int size() {
                    return MarketBlockEntity.this.itemHandler.getSlots();
                }
            };
            ++this.ticksSinceLastDamage;
            if (this.ticksSinceLastDamage >= (Integer)ModConfig.ticksSinceLastDamage.get()) {
                this.itemHandler.getStackInSlot(this.LICENCE_SLOT).hurtAndBreak(1, (LivingEntity)this.fakePlayer, this.fakePlayer.getEquipmentSlotForItem(ItemStack.EMPTY));
                this.ticksSinceLastDamage = 0;
            }
            if (this.itemHandler.getStackInSlot(this.LICENCE_SLOT).isEmpty()) {
                this.currentRecipe = null;
                this.recipeID = null;
                this.needNewRecipe = true;
            }
            for (int i = this.previousOrders.length - 1; i >= 0; --i) {
                int n = i;
                this.previousOrders[n] = this.previousOrders[n] - 1;
                if (this.previousOrders[i] != 0) continue;
                this.previousOrders = ArrayUtils.remove((int[])this.previousOrders, (int)i);
                this.demand += 0.1;
                if (!(this.demand > 1.0)) continue;
                this.demand = 1.0;
            }
            if (!this.itemHandler.getStackInSlot(this.LICENCE_SLOT).getItem().asItem().getDefaultInstance().is(ModTags.NO_DEMAND)) {
                if (this.previousOrders.length > 2) {
                    this.demand = 1.0 - 0.1 * (double)(this.previousOrders.length / 3);
                    if (this.demand < 0.2) {
                        this.demand = 0.2;
                    }
                }
            } else {
                this.demand = 1.0;
            }
            if (this.recipeID != null && this.currentRecipe == null && (recipe = this.level.getRecipeManager().byKey(this.recipeID)).isPresent()) {
                this.currentRecipe = (RecipeHolder)recipe.get();
                this.needNewRecipe = false;
            }
            if (this.needNewRecipe && this.hasValidLicense()) {
                RandomSource random = RandomSource.create();
                this.currentRecipe = this.getRandomRecipe(random);
                this.recipeID = ResourceLocation.parse((String)this.currentRecipe.toString());
                this.needNewRecipe = false;
                int variation = ((MarketRecipe)this.currentRecipe.value()).variation();
                this.orderVariation = random.nextIntBetweenInclusive(-variation, variation);
            }
            if (this.currentRecipe == null) {
                return;
            }
            if (((MarketRecipe)this.currentRecipe.value()).inputWithNbt().isEmpty()) {
                inputAmount = (int)((double)(((MarketRecipe)this.currentRecipe.value()).input().count() + this.orderVariation) / this.demand);
                if (inputAmount > ((MarketRecipe)this.currentRecipe.value()).input().getItems()[0].getMaxStackSize()) {
                    inputAmount = ((MarketRecipe)this.currentRecipe.value()).input().getItems()[0].getMaxStackSize();
                }
                this.useNBT = false;
            } else {
                inputAmount = (int)((double)(((MarketRecipe)this.currentRecipe.value()).inputWithNbt().getCount() + this.orderVariation) / this.demand);
                if (inputAmount > ((MarketRecipe)this.currentRecipe.value()).inputWithNbt().getMaxStackSize()) {
                    inputAmount = ((MarketRecipe)this.currentRecipe.value()).inputWithNbt().getMaxStackSize();
                }
                this.useNBT = true;
            }
            int totalAmount = 0;
            ArrayList<Integer> validSlots = new ArrayList<Integer>();
            if (!this.useNBT) {
                for (i = 1; i < 10; ++i) {
                    ItemStack slotStack = this.itemHandler.getStackInSlot(i);
                    if (slotStack.isEmpty()) continue;
                    for (ItemStack itemStack : ((MarketRecipe)this.currentRecipe.value()).input().getItems()) {
                        if (itemStack.getItem() != slotStack.getItem()) continue;
                        validSlots.add(i);
                        totalAmount += slotStack.getCount();
                    }
                }
            } else {
                for (i = 0; i < 10; ++i) {
                    DataComponentMap inputComponents;
                    DataComponentMap recipeComponents;
                    if (this.itemHandler.getStackInSlot(i).isEmpty() || this.itemHandler.getStackInSlot(i).getItem() != ((MarketRecipe)this.currentRecipe.value()).inputWithNbt().getItem() || !(recipeComponents = ((MarketRecipe)this.currentRecipe.value()).inputWithNbt().getComponents()).equals((Object)(inputComponents = this.itemHandler.getStackInSlot(i).getComponents()))) continue;
                    validSlots.add(i);
                    totalAmount += this.itemHandler.getStackInSlot(i).getCount();
                }
            }
            if (totalAmount < inputAmount) {
                return;
            }
            int outputSpace = 0;
            for (int k = 10; k <= 12; ++k) {
                if (this.itemHandler.getStackInSlot(k).isEmpty()) {
                    outputSpace += ((MarketRecipe)this.currentRecipe.value()).output().getMaxStackSize();
                    continue;
                }
                if (this.itemHandler.getStackInSlot(k).getItem() != ((MarketRecipe)this.currentRecipe.value()).output().getItem()) continue;
                outputSpace += this.itemHandler.getStackInSlot(k).getMaxStackSize() - this.itemHandler.getStackInSlot(k).getCount();
            }
            if (outputSpace < ((MarketRecipe)this.currentRecipe.value()).output().getCount()) {
                return;
            }
            Iterator k = validSlots.iterator();
            while (k.hasNext()) {
                int slot = (Integer)k.next();
                if (inputAmount > this.itemHandler.getStackInSlot(slot).getCount()) {
                    inputAmount -= this.itemHandler.getStackInSlot(slot).getCount();
                    this.itemHandler.setStackInSlot(slot, ItemStack.EMPTY);
                    continue;
                }
                this.itemHandler.getStackInSlot(slot).shrink(inputAmount);
                inputAmount = 0;
            }
            int outputAmount = ((MarketRecipe)this.currentRecipe.value()).output().getCount();
            for (int i = 10; i <= 12; ++i) {
                if (this.itemHandler.getStackInSlot(i).isEmpty()) {
                    if (outputAmount <= ((MarketRecipe)this.currentRecipe.value()).output().getMaxStackSize()) {
                        this.itemHandler.setStackInSlot(i, new ItemStack((ItemLike)((MarketRecipe)this.currentRecipe.value()).output().getItem(), outputAmount));
                        this.previousOrders = ArrayUtils.add((int[])this.previousOrders, (int)600);
                        this.needNewRecipe = true;
                        break;
                    }
                    this.itemHandler.setStackInSlot(i, new ItemStack((ItemLike)((MarketRecipe)this.currentRecipe.value()).output().getItem(), ((MarketRecipe)this.currentRecipe.value()).output().getMaxStackSize()));
                    continue;
                }
                if (this.itemHandler.getStackInSlot(i).getItem() != ((MarketRecipe)this.currentRecipe.value()).output().getItem()) continue;
                int slotSpace = this.itemHandler.getStackInSlot(i).getMaxStackSize() - this.itemHandler.getStackInSlot(i).getCount();
                if (outputAmount <= slotSpace) {
                    this.itemHandler.getStackInSlot(i).grow(outputAmount);
                    this.previousOrders = ArrayUtils.add((int[])this.previousOrders, (int)600);
                    this.needNewRecipe = true;
                    break;
                }
                this.itemHandler.getStackInSlot(i).setCount(this.itemHandler.getStackInSlot(i).getMaxStackSize());
                outputAmount -= slotSpace;
            }
        }
    }

    private void completeRecipe(int inputCount, int slot, ItemStack output) {
        int outputCount = output.getCount();
        int outputSpace = 0;
        for (int k = 10; k <= 12; ++k) {
            if (this.itemHandler.getStackInSlot(k).isEmpty()) {
                outputSpace += output.getMaxStackSize();
            }
            if (this.itemHandler.getStackInSlot(k).getItem() != output.getItem()) continue;
            outputSpace += this.itemHandler.getStackInSlot(k).getMaxStackSize() - this.itemHandler.getStackInSlot(k).getCount();
        }
        if (outputSpace < outputCount) {
            return;
        }
        for (int i = 10; i <= 12; ++i) {
            ItemStack outputSlot = this.itemHandler.getStackInSlot(i);
            if (outputSlot.isEmpty()) {
                if (outputCount <= output.getMaxStackSize()) {
                    this.itemHandler.setStackInSlot(i, output.copy());
                    this.itemHandler.getStackInSlot(slot).shrink(inputCount);
                    this.needNewRecipe = true;
                    this.previousOrders = ArrayUtils.add((int[])this.previousOrders, (int)1200);
                    break;
                }
                this.itemHandler.setStackInSlot(i, new ItemStack((ItemLike)output.getItem(), output.getMaxStackSize()));
                continue;
            }
            if (outputSlot.getItem() != output.getItem()) continue;
            if (outputSlot.getCount() + outputCount <= outputSlot.getMaxStackSize()) {
                outputSlot.grow(outputCount);
                this.itemHandler.getStackInSlot(slot).shrink(inputCount);
                this.needNewRecipe = true;
                this.previousOrders = ArrayUtils.add((int[])this.previousOrders, (int)1200);
                break;
            }
            output.shrink(outputSlot.getMaxStackSize() - outputSlot.getCount());
            outputSlot.setCount(outputSlot.getMaxStackSize());
        }
    }

    private boolean hasValidLicense() {
        if (this.itemHandler.getStackInSlot(this.LICENCE_SLOT).isEmpty()) {
            return false;
        }
        assert (this.level != null);
        List recipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)MarketRecipe.Type.INSTANCE);
        for (int i = 0; i < recipes.size(); ++i) {
            if (!((MarketRecipe)((RecipeHolder)recipes.get(i)).value()).license().test(this.itemHandler.getStackInSlot(this.LICENCE_SLOT))) continue;
            return true;
        }
        return false;
    }

    private RecipeHolder<MarketRecipe> getRandomRecipe(RandomSource random) {
        assert (this.level != null);
        List recipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)MarketRecipe.Type.INSTANCE);
        ArrayList<RecipeHolder> availableRecipes = new ArrayList<RecipeHolder>();
        for (int i = recipes.size() - 1; i >= 0; --i) {
            if (!((MarketRecipe)((RecipeHolder)recipes.get(i)).value()).license().test(this.itemHandler.getStackInSlot(this.LICENCE_SLOT))) continue;
            availableRecipes.add((RecipeHolder)recipes.get(i));
        }
        int index = random.nextIntBetweenInclusive(0, availableRecipes.size() - 1);
        return (RecipeHolder)availableRecipes.get(index);
    }

    private FakePlayer createFakePlayer(ServerLevel level) {
        return new FakePlayer(level, new GameProfile(UUID.randomUUID(), "Market"));
    }
}

