/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.handler;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.block.entity.WirelessChargerBlockEntity;
import se.gory_moon.chargers.compat.Curios;

@EventBusSubscriber(modid="chargers")
public class WirelessHandler {
    public static WirelessHandler INSTANCE = new WirelessHandler();
    private final Object2ObjectMap<ResourceLocation, ObjectSet<BlockPos>> dimensionChargers = new Object2ObjectOpenHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(WirelessChargerBlockEntity charger, Level level) {
        Object2ObjectMap<ResourceLocation, ObjectSet<BlockPos>> object2ObjectMap = this.dimensionChargers;
        synchronized (object2ObjectMap) {
            this.getDimensionChargers(level).add((Object)new BlockPos((Vec3i)charger.getBlockPos()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(WirelessChargerBlockEntity charger, @Nullable Level level) {
        if (level == null) {
            return;
        }
        Object2ObjectMap<ResourceLocation, ObjectSet<BlockPos>> object2ObjectMap = this.dimensionChargers;
        synchronized (object2ObjectMap) {
            this.getDimensionChargers(level).remove((Object)charger.getBlockPos());
        }
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Pre event) {
        if (event.getEntity().level().isClientSide() || event.getEntity().isSpectator()) {
            return;
        }
        INSTANCE.chargeItems(event.getEntity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chargeItems(Player player) {
        Object2ObjectMap<ResourceLocation, ObjectSet<BlockPos>> object2ObjectMap = this.dimensionChargers;
        synchronized (object2ObjectMap) {
            ObjectSet<BlockPos> chargers = this.getDimensionChargers(player.level());
            if (chargers.isEmpty()) {
                return;
            }
            BlockPos playerPos = player.blockPosition();
            ObjectIterator iterator = chargers.iterator();
            while (iterator.hasNext()) {
                BlockPos pos = (BlockPos)iterator.next();
                WirelessChargerBlockEntity charger = this.getCharger(player.level(), pos);
                if (charger != null) {
                    if (!charger.canCharge() || !this.inRange(charger.getBlockPos(), playerPos) || !this.chargeItems(player, charger)) continue;
                    return;
                }
                iterator.remove();
            }
        }
    }

    @Nullable
    private WirelessChargerBlockEntity getCharger(Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (level.isAreaLoaded(pos, 1) && (blockEntity = level.getBlockEntity(pos)) instanceof WirelessChargerBlockEntity) {
            return (WirelessChargerBlockEntity)blockEntity;
        }
        return null;
    }

    private boolean chargeItems(Player player, WirelessChargerBlockEntity charger) {
        charger.updateAvailable();
        boolean result = charger.chargeItems((NonNullList<ItemStack>)player.getInventory().armor);
        result |= charger.chargeItems((NonNullList<ItemStack>)player.getInventory().items);
        result |= charger.chargeItems((NonNullList<ItemStack>)player.getInventory().offhand);
        if (result |= Curios.INSTANCE.chargeItems(player, charger)) {
            player.inventoryMenu.broadcastChanges();
        }
        return result;
    }

    private boolean inRange(BlockPos a, BlockPos b) {
        int range = (Integer)Configs.SERVER.wireless.range.get();
        int dx = a.getX() - b.getX();
        if (dx > range || dx < -range) {
            return false;
        }
        int dz = a.getZ() - b.getZ();
        if (dz > range || dz < -range) {
            return false;
        }
        int dy = a.getY() - b.getY();
        return dx * dx + dy * dy + dz * dz <= range * range;
    }

    private ObjectSet<BlockPos> getDimensionChargers(Level level) {
        return (ObjectSet)this.dimensionChargers.computeIfAbsent((Object)level.dimension().location(), location -> new ObjectOpenHashSet());
    }
}

