/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.chargers.block.BlockRegistry;
import se.gory_moon.chargers.crafting.UpgradeChargerRecipeBuilder;
import se.gory_moon.chargers.item.ItemRegistry;

public class ChargerRecipeProvider
extends RecipeProvider {
    public ChargerRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput output) {
        BlockItem chargerT1Item = (BlockItem)ItemRegistry.CHARGER_T1_ITEM.get();
        BlockItem chargerT2Item = (BlockItem)ItemRegistry.CHARGER_T2_ITEM.get();
        BlockItem chargerT3Item = (BlockItem)ItemRegistry.CHARGER_T3_ITEM.get();
        BlockItem chargerT4Item = (BlockItem)ItemRegistry.CHARGER_T4_ITEM.get();
        Ingredient iron = Ingredient.of((TagKey)Tags.Items.INGOTS_IRON);
        Ingredient redstone = Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE);
        Ingredient redstoneBlock = Ingredient.of((TagKey)Tags.Items.STORAGE_BLOCKS_REDSTONE);
        Ingredient gold = Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD);
        Ingredient diamond = Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND);
        Ingredient netherite = Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE);
        Ingredient enderPearls = Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS);
        Ingredient chargerT1 = Ingredient.of((ItemLike[])new ItemLike[]{chargerT1Item});
        Ingredient chargerT2 = Ingredient.of((ItemLike[])new ItemLike[]{chargerT2Item});
        Ingredient chargerT3 = Ingredient.of((ItemLike[])new ItemLike[]{chargerT3Item});
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)chargerT1Item).define(Character.valueOf('I'), iron).define(Character.valueOf('R'), redstone).define(Character.valueOf('B'), redstoneBlock).pattern("IRI").pattern("IBI").pattern("IRI").unlockedBy("has_ingots_iron", ChargerRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_dusts_redstone", ChargerRecipeProvider.has((TagKey)Tags.Items.DUSTS_REDSTONE)).unlockedBy("has_storage_blocks_redstone", ChargerRecipeProvider.has((TagKey)Tags.Items.STORAGE_BLOCKS_REDSTONE)).save(output);
        new UpgradeChargerRecipeBuilder(RecipeCategory.REDSTONE, (ItemLike)chargerT2Item).define(Character.valueOf('G'), gold).define(Character.valueOf('R'), redstone).define(Character.valueOf('B'), redstoneBlock).define(Character.valueOf('C'), chargerT1).pattern("GRG").pattern("GBG").pattern("GCG").unlockedBy("has_charger_t1", ChargerRecipeProvider.has((ItemLike)chargerT1Item)).save(output);
        new UpgradeChargerRecipeBuilder(RecipeCategory.REDSTONE, (ItemLike)chargerT3Item).define(Character.valueOf('D'), diamond).define(Character.valueOf('R'), redstone).define(Character.valueOf('B'), redstoneBlock).define(Character.valueOf('C'), chargerT2).pattern("DRD").pattern("DBD").pattern("DCD").unlockedBy("has_charger_t2", ChargerRecipeProvider.has((ItemLike)chargerT2Item)).save(output);
        new UpgradeChargerRecipeBuilder(RecipeCategory.REDSTONE, (ItemLike)chargerT4Item).define(Character.valueOf('N'), netherite).define(Character.valueOf('R'), redstone).define(Character.valueOf('B'), redstoneBlock).define(Character.valueOf('C'), chargerT3).pattern("NRN").pattern("NBN").pattern("NCN").unlockedBy("has_charger_t3", ChargerRecipeProvider.has((ItemLike)chargerT3Item)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)BlockRegistry.WIRELESS_CHARGER.get())).define(Character.valueOf('I'), iron).define(Character.valueOf('R'), redstone).define(Character.valueOf('B'), redstoneBlock).define(Character.valueOf('E'), enderPearls).pattern("IEI").pattern("IBI").pattern("IRI").unlockedBy("has_ender_pearls", ChargerRecipeProvider.has((TagKey)Tags.Items.ENDER_PEARLS)).unlockedBy("has_ingots_iron", ChargerRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).unlockedBy("has_dusts_redstone", ChargerRecipeProvider.has((TagKey)Tags.Items.DUSTS_REDSTONE)).unlockedBy("has_storage_blocks_redstone", ChargerRecipeProvider.has((TagKey)Tags.Items.STORAGE_BLOCKS_REDSTONE)).save(output);
    }
}

