/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.compat.fn;

import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.block.ChargerBlock;
import se.gory_moon.chargers.block.entity.BlockEntityRegistry;
import se.gory_moon.chargers.compat.fn.FNStorageWrapper;
import se.gory_moon.chargers.item.ItemRegistry;
import se.gory_moon.chargers.power.CustomItemEnergyStorage;
import sonar.fluxnetworks.api.FluxCapabilities;

public class FluxNetworksCompat {
    public static FluxNetworksCompat INSTANCE = new FluxNetworksCompat();
    boolean loaded = ModList.get().isLoaded("fluxnetworks");

    private FluxNetworksCompat() {
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void registerFNCapability(@NotNull RegisterCapabilitiesEvent event) {
        if (this.loaded) {
            CapabilityRegister.registerFNCapability(event);
        }
    }

    private static final class CapabilityRegister {
        private CapabilityRegister() {
        }

        private static void registerFNCapability(@NotNull RegisterCapabilitiesEvent event) {
            event.registerBlockEntity(FluxCapabilities.BLOCK, BlockEntityRegistry.CHARGER_BE.get(), (entity, side) -> new FNStorageWrapper(entity.getStorage()));
            event.registerBlockEntity(FluxCapabilities.BLOCK, BlockEntityRegistry.WIRELESS_CHARGER_BE.get(), (entity, side) -> new FNStorageWrapper(entity.getStorage()));
            event.registerItem(FluxCapabilities.ITEM, (stack, context) -> {
                ChargerBlock block = (ChargerBlock)((BlockItem)stack.getItem()).getBlock();
                ChargerBlock.Tier tier = block.getTier();
                return new FNStorageWrapper(new CustomItemEnergyStorage((ItemStack)stack, tier.getStorage(), tier.getMaxIn(), tier.getMaxOut(), tier.isCreative()));
            }, new ItemLike[]{ItemRegistry.CHARGER_T1_ITEM, ItemRegistry.CHARGER_T2_ITEM, ItemRegistry.CHARGER_T3_ITEM, ItemRegistry.CHARGER_T4_ITEM, ItemRegistry.CHARGER_CREATIVE_ITEM});
            event.registerItem(FluxCapabilities.ITEM, (stack, context) -> new FNStorageWrapper(new CustomItemEnergyStorage((ItemStack)stack, (long)((Long)Configs.SERVER.wireless.storage.get()), (long)((Long)Configs.SERVER.wireless.maxInput.get()), (Long)Configs.SERVER.wireless.maxOutput.get())), new ItemLike[]{ItemRegistry.CHARGER_WIRELESS_ITEM});
        }
    }
}

