/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import se.gory_moon.chargers.inventory.ChargerData;
import se.gory_moon.chargers.item.ChargerDataComponents;
import se.gory_moon.chargers.power.CustomEnergyStorage;

public abstract class EnergyHolderBlockEntity
extends BlockEntity
implements Nameable {
    public static final String STORAGE_TAG = "Storage";
    public static final String CUSTOM_NAME_TAG = "CustomName";
    @Nullable
    protected Component name;
    @Nullable
    private CustomEnergyStorage storage = null;
    protected final ChargerData energyData = new ChargerData(){

        @Override
        public long get(int index) {
            return switch (index) {
                case 0 -> EnergyHolderBlockEntity.this.storage.getLongEnergyStored();
                case 1 -> EnergyHolderBlockEntity.this.storage.getLongMaxEnergyStored();
                case 2 -> EnergyHolderBlockEntity.this.storage.getMaxInput();
                case 3 -> EnergyHolderBlockEntity.this.storage.getMaxOutput();
                case 4 -> EnergyHolderBlockEntity.this.storage.getAverageIn();
                case 5 -> EnergyHolderBlockEntity.this.storage.getAverageOut();
                case 6 -> {
                    if (EnergyHolderBlockEntity.this.storage.isCreative()) {
                        yield 1L;
                    }
                    yield 0L;
                }
                default -> 0L;
            };
        }

        @Override
        public void set(int index, long value) {
        }

        @Override
        public int getCount() {
            return 7;
        }
    };

    public EnergyHolderBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public void setStorage(CustomEnergyStorage storage) {
        this.storage = storage;
        this.invalidateCapabilities();
    }

    @Nullable
    public CustomEnergyStorage getStorage() {
        return this.storage;
    }

    public void tickServer() {
        if (this.storage != null) {
            this.storage.tick();
        }
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput componentInput) {
        this.name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
        if (this.storage != null) {
            this.storage.setEnergy((Long)componentInput.getOrDefault(ChargerDataComponents.ENERGY, (Object)0L));
        }
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder components) {
        components.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        if (this.storage != null) {
            components.set(ChargerDataComponents.ENERGY, (Object)this.storage.getLongEnergyStored());
        }
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (this.storage != null) {
            this.storage.deserializeNBT(registries, (Tag)tag.getCompound(STORAGE_TAG));
        }
        if (tag.contains(CUSTOM_NAME_TAG, 8)) {
            this.name = EnergyHolderBlockEntity.parseCustomNameSafe((String)tag.getString(CUSTOM_NAME_TAG), (HolderLookup.Provider)registries);
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.storage != null) {
            tag.put(STORAGE_TAG, this.storage.serializeNBT(registries));
        }
        if (this.name != null) {
            tag.putString(CUSTOM_NAME_TAG, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, EnergyHolderBlockEntity blockEntity) {
        blockEntity.tickServer();
    }

    @NotNull
    public Component getName() {
        Component name = this.getCustomName();
        if (name == null) {
            name = this.getBlockState().getBlock().getName();
        }
        return name;
    }

    public boolean hasCustomName() {
        return this.name != null;
    }

    @NotNull
    public Component getDisplayName() {
        return this.hasCustomName() ? this.getCustomName() : this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }
}

