/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.block.entity;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ChargerItemStackHandler
extends ItemStackHandler {
    private static final int SIZE = 3;

    public ChargerItemStackHandler() {
        super(NonNullList.withSize((int)3, (Object)ItemStack.EMPTY));
    }

    public void setSize(int size) {
        this.stacks = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (!stack.isEmpty()) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (slot == 0) {
                return (storage != null ? storage.receiveEnergy(1, true) : 0) > 0;
            }
            if (slot == 2) {
                return (storage != null ? storage.extractEnergy(1, true) : 0) > 0;
            }
        }
        return false;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if ((slot == 0 || slot == 2) && this.isItemValid(slot, stack)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        IEnergyStorage storage;
        if (slot == 0) {
            return ItemStack.EMPTY;
        }
        if (slot == 2 && ((storage = (IEnergyStorage)this.getStackInSlot(2).getCapability(Capabilities.EnergyStorage.ITEM)) != null ? storage.extractEnergy(1, true) : 0) > 0) {
            return ItemStack.EMPTY;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }
}

