/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import se.gory_moon.chargers.block.ChargerBlock;
import se.gory_moon.chargers.block.entity.BlockEntityRegistry;
import se.gory_moon.chargers.block.entity.ChargerItemStackHandler;
import se.gory_moon.chargers.block.entity.EnergyHolderBlockEntity;
import se.gory_moon.chargers.compat.ChargeCompat;
import se.gory_moon.chargers.inventory.ChargerMenu;
import se.gory_moon.chargers.power.CustomEnergyStorage;

public class ChargerBlockEntity
extends EnergyHolderBlockEntity
implements MenuProvider {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int CHARGE_SLOT = 2;
    private final ChargerItemStackHandler inventoryHandler = new ChargerItemStackHandler(){

        protected void onContentsChanged(int slot) {
            ChargerBlockEntity.this.setChanged();
        }
    };

    public ChargerBlockEntity(BlockPos pos, BlockState state, ChargerBlock.Tier tier) {
        super(BlockEntityRegistry.CHARGER_BE.get(), pos, state);
        this.setTier(tier);
    }

    public ChargerBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, ((ChargerBlock)state.getBlock()).getTier());
    }

    public ChargerItemStackHandler getInventoryHandler() {
        return this.inventoryHandler;
    }

    public void setTier(ChargerBlock.Tier tier) {
        this.setStorage(new CustomEnergyStorage(tier.getStorage(), tier.getMaxIn(), tier.getMaxOut(), tier.isCreative()));
    }

    @Override
    public void tickServer() {
        CustomEnergyStorage storage = this.getStorage();
        if (storage != null) {
            boolean isFull;
            ItemStack charge = this.inventoryHandler.getStackInSlot(2);
            if (!charge.isEmpty()) {
                ChargeCompat.INSTANCE.dischargeItem(charge, storage, () -> ((ChargerBlockEntity)this).setChanged());
            }
            ItemStack input = this.inventoryHandler.getStackInSlot(0);
            ItemStack output = this.inventoryHandler.getStackInSlot(1);
            if (!input.isEmpty() && input.getCount() == 1 && storage.getLongEnergyStored() > 0L && (isFull = ChargeCompat.INSTANCE.chargeItem(input, storage, t -> {
                storage.extractLongEnergy((long)t, false);
                this.setChanged();
            })) && output.isEmpty()) {
                this.inventoryHandler.setStackInSlot(1, input);
                this.inventoryHandler.setStackInSlot(0, ItemStack.EMPTY);
            }
        }
        super.tickServer();
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventoryHandler.deserializeNBT(registries, tag);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.merge(this.inventoryHandler.serializeNBT(registries));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new ChargerMenu(containerId, playerInventory, this.inventoryHandler, this.energyData, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.getBlockPos()));
    }
}

