/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.EnergyFormatting;
import se.gory_moon.chargers.LangKeys;
import se.gory_moon.chargers.block.BlockRegistry;
import se.gory_moon.chargers.block.EnergyBlock;
import se.gory_moon.chargers.block.entity.BlockEntityRegistry;
import se.gory_moon.chargers.block.entity.ChargerBlockEntity;
import se.gory_moon.chargers.block.entity.ChargerItemStackHandler;

public class ChargerBlock
extends EnergyBlock {
    private final Tier tier;

    public ChargerBlock(Tier tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return (MapCodec)BlockRegistry.CHARGER_CODEC.value();
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult result) {
        if (!level.isClientSide && player instanceof ServerPlayer) {
            player.openMenu(state.getMenuProvider(level, pos));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void onRemove(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof ChargerBlockEntity) {
            ChargerBlockEntity chargerEntity = (ChargerBlockEntity)blockEntity;
            ChargerItemStackHandler inventoryHandler = chargerEntity.getInventoryHandler();
            for (int i = 0; i < inventoryHandler.getSlots(); ++i) {
                ItemStack stack = inventoryHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag tooltipFlag) {
        Tier tier = this.getTier();
        if (tier.isCreative()) {
            tooltip.add((Component)Component.translatable((String)LangKeys.POWER_INFO.key(), (Object[])new Object[]{EnergyFormatting.INFINITE}).withStyle(ChatFormatting.GOLD));
        } else {
            EnergyFormatting.addEnergyTooltip(stack, tooltip);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return ChargerBlock.createEnergyTicker(level, type, BlockEntityRegistry.CHARGER_BE.get());
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ChargerBlockEntity(pos, state, this.tier);
    }

    public Tier getTier() {
        return this.tier;
    }

    public static enum Tier implements StringRepresentable
    {
        I(0, "tier_1", () -> Configs.SERVER.tier1),
        II(1, "tier_2", () -> Configs.SERVER.tier2),
        III(2, "tier_3", () -> Configs.SERVER.tier3),
        IV(3, "tier_4", () -> Configs.SERVER.tier4),
        C(4, "creative", () -> Configs.SERVER.tier4);

        private final int id;
        private final String name;
        private final Supplier<Configs.Server.Tier> tierSupplier;
        @Nullable
        private Configs.Server.Tier tier = null;
        public static final Codec<Tier> CODEC;

        private Tier(int id, String name, Supplier<Configs.Server.Tier> tierSupplier) {
            this.id = id;
            this.name = name;
            this.tierSupplier = tierSupplier;
        }

        public int getId() {
            return this.id;
        }

        public boolean isCreative() {
            return this == C;
        }

        public long getStorage() {
            return (Long)this.getTierConfig().storage.get();
        }

        public long getMaxIn() {
            return (Long)this.getTierConfig().maxInput.get();
        }

        public long getMaxOut() {
            return (Long)this.getTierConfig().maxOutput.get();
        }

        private Configs.Server.Tier getTierConfig() {
            if (this.tier == null) {
                this.tier = this.tierSupplier.get();
            }
            return this.tier;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Tier::values);
        }
    }
}

