/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import se.gory_moon.chargers.LangKeys;
import se.gory_moon.chargers.power.CustomEnergyStorage;

public class EnergyFormatting {
    public static Component FE = Component.literal((String)" FE").withStyle(ChatFormatting.DARK_AQUA);
    public static Component SLASH = Component.literal((String)"/").withStyle(ChatFormatting.GOLD);
    public static Component FE_TICK = FE.copy().append(SLASH).append((Component)Component.literal((String)"t").withStyle(ChatFormatting.DARK_AQUA));
    public static Component POSITIVE = Component.literal((String)"+").withStyle(ChatFormatting.GREEN);
    public static Component NEGATIVE = Component.literal((String)"-").withStyle(ChatFormatting.RED);
    public static Component INFINITE = Component.literal((String)"\u221e").withStyle(ChatFormatting.WHITE).append(FE);

    public static Component formatAndClean(long number) {
        return Component.literal((String)new DecimalFormat().format(number)).withStyle(ChatFormatting.WHITE);
    }

    public static Component formatEnergyPerTick(long energy) {
        return EnergyFormatting.formatAndClean(Math.abs(energy)).copy().append(FE_TICK).withStyle(ChatFormatting.WHITE);
    }

    public static Component formatFilledCapacity(long amount, long capacity) {
        return Component.translatable((String)LangKeys.POWER_INFO.key(), (Object[])new Object[]{EnergyFormatting.formatAndClean(amount).copy().append(SLASH).append(EnergyFormatting.formatAndClean(capacity)).append(FE)}).withStyle(ChatFormatting.GOLD);
    }

    public static void addEnergyTooltip(ItemStack stack, List<Component> tooltip) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage != null) {
            long max;
            long stored;
            if (energyStorage instanceof CustomEnergyStorage) {
                CustomEnergyStorage storage = (CustomEnergyStorage)energyStorage;
                stored = storage.getLongEnergyStored();
                max = storage.getLongMaxEnergyStored();
            } else {
                stored = energyStorage.getEnergyStored();
                max = energyStorage.getMaxEnergyStored();
            }
            tooltip.add(EnergyFormatting.formatFilledCapacity(stored, max));
        }
    }
}

