/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.util.InclusiveRange;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.LangKeys;
import se.gory_moon.chargers.block.BlockRegistry;
import se.gory_moon.chargers.block.entity.BlockEntityRegistry;
import se.gory_moon.chargers.crafting.RecipeSerializers;
import se.gory_moon.chargers.data.ChargerBlockStateProvider;
import se.gory_moon.chargers.data.ChargerBlockTagsProvider;
import se.gory_moon.chargers.data.ChargerItemModelProvider;
import se.gory_moon.chargers.data.ChargerLanguageProvider;
import se.gory_moon.chargers.data.ChargerLootTableProvider;
import se.gory_moon.chargers.data.ChargerRecipeProvider;
import se.gory_moon.chargers.handler.CapabilityRegistrationHandler;
import se.gory_moon.chargers.item.ChargerDataComponents;
import se.gory_moon.chargers.item.ItemRegistry;
import se.gory_moon.chargers.network.PayloadRegister;

@Mod(value="chargers")
public class ChargersMod {
    public ChargersMod(IEventBus modBus, ModContainer container) {
        modBus.addListener(this::gatherData);
        modBus.addListener(PayloadRegister::onPayloadRegister);
        modBus.addListener(CapabilityRegistrationHandler::registerCapabilities);
        BlockRegistry.BLOCKS.register(modBus);
        BlockRegistry.BLOCK_TYPES.register(modBus);
        BlockEntityRegistry.BlOCK_ENTITIES.register(modBus);
        BlockEntityRegistry.MENU_TYPES.register(modBus);
        ItemRegistry.ITEMS.register(modBus);
        ItemRegistry.CREATIVE_TABS.register(modBus);
        ChargerDataComponents.DATA_COMPONENTS.register(modBus);
        RecipeSerializers.RECIPE_SERIALIZER.register(modBus);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Configs.serverSpec);
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        gen.addProvider(true, (DataProvider)new PackMetadataGenerator(packOutput).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.translatable((String)LangKeys.PACK_DESCRIPTION.key()), DetectedVersion.BUILT_IN.getPackVersion(PackType.SERVER_DATA), Optional.of(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE))))));
        gen.addProvider(event.includeClient(), (DataProvider)new ChargerLanguageProvider(packOutput));
        gen.addProvider(event.includeClient(), (DataProvider)new ChargerBlockStateProvider(packOutput, existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ChargerItemModelProvider(packOutput, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ChargerBlockTagsProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ChargerRecipeProvider(packOutput, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new ChargerLootTableProvider(packOutput, lookupProvider));
    }
}

