/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.validator;

import com.mojang.blaze3d.platform.NativeImage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImageValidator {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private ImageValidator() {
    }

    public static boolean isValidImage(NativeImage image) {
        if (image == null) {
            log.error("Found no valid image data in native image!");
            return false;
        }
        if (image.getWidth() == 48 && image.getHeight() == 32) {
            return true;
        }
        if (image.getWidth() < 32 || image.getHeight() < 32 || image.getWidth() % 32 != 0 || image.getHeight() % 32 != 0) {
            log.error("Unable to get any valid texture from native image, got {}x{}!", (Object)image.getWidth(), (Object)image.getHeight());
            return false;
        }
        return true;
    }
}

