/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu;

import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.menu.dialog.DialogMenu;
import de.markusbordihn.easynpc.menu.dialog.DialogMenuHandler;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.MenuType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface MenuHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    default public void openDialogMenu(ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, int pageIndex) {
        MenuType<? extends DialogMenu> menuType = this.getDialogMenuType();
        if (menuType == null) {
            log.error("Unknown dialog for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ScreenData screenData = DialogMenuHandler.getScreenData(easyNPC, dialogId, pageIndex, serverPlayer);
        MenuProvider menuProvider = DialogMenuHandler.getMenuProvider(easyNPC, menuType, screenData);
        UUID npcUUID = easyNPC.getEntityUUID();
        MenuManager.openMenu(npcUUID, menuProvider, serverPlayer, screenData.encode());
    }

    public MenuType<? extends DialogMenu> getDialogMenuType();
}

