/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.io.BackupDataFiles;
import de.markusbordihn.easynpc.io.CustomPoseDataFiles;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.CustomSkinDataFiles;
import de.markusbordihn.easynpc.io.PlayerSkinDataFiles;
import de.markusbordihn.easynpc.io.RemoteSkinDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataFileHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final String BACKUP_FOLDER_NAME = "backup";
    protected static final String CACHE_FOLDER_NAME = "cache";
    protected static final String RESOURCE_PRESET_PATH = "preset";
    protected static final String RESOURCE_DEFAULT_PRESET_PATH = "default_preset";
    protected static final String RESOURCE_POSES_PATH = "poses";
    protected static final String RESOURCE_TEXTURES_ENTITY_PATH = "textures/entity";
    private static final Pattern VALID_PRESET_FILENAME_PATTERN = Pattern.compile("[a-zA-Z0-9/._-]+");

    private DataFileHandler() {
    }

    public static boolean isValidPresetFilename(String filename) {
        return VALID_PRESET_FILENAME_PATTERN.matcher(filename).matches();
    }

    public static boolean isValidPresetFilename(Path path) {
        return DataFileHandler.isValidPresetFilename(path.getFileName().toString());
    }

    public static boolean isPresetFile(Path path) {
        return path.toString().endsWith(".npc.nbt") && DataFileHandler.isValidPresetFilename(path);
    }

    public static boolean isPresetFile(ResourceLocation resourceLocation) {
        return resourceLocation.toString().endsWith(".npc.nbt");
    }

    public static String getPresetFileName(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        String result = fileName.replaceAll("[^a-zA-Z0-9/._-]", "").replace("..", "").replace("/", "_");
        if (result.isEmpty() || !VALID_PRESET_FILENAME_PATTERN.matcher(result).matches()) {
            return null;
        }
        return result.endsWith(".npc.nbt") ? result : result + ".npc.nbt";
    }

    public static void registerCommonDataFiles() {
        log.info("{} Common data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        DataFileHandler.getCacheFolder();
        DataFileHandler.getCustomDataFolder();
    }

    public static void registerServerDataFiles(MinecraftServer minecraftServer) {
        log.info("{} Server data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        log.info("{} Pose data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        CustomPoseDataFiles.registerCustomPoseData(minecraftServer);
        log.info("{} Backup data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        BackupDataFiles.registerBackupData();
        log.info("{} Preset data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        CustomPresetDataFiles.registerCustomPresetData();
        WorldPresetDataFiles.registerWorldPresetData();
    }

    public static void registerClientDataFiles() {
        log.info("{} Client data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        log.info("{} Skin data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        CustomSkinDataFiles.registerCustomSkinData();
        PlayerSkinDataFiles.registerPlayerSkinData();
        RemoteSkinDataFiles.registerRemoteSkinData();
        log.info("{} Preset data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        CustomPresetDataFiles.registerCustomPresetData();
    }

    public static Path getBackupFolder() {
        Path backupFolder = Constants.GAME_DIR.resolve("easy_npc").resolve(BACKUP_FOLDER_NAME);
        try {
            if (Files.exists(backupFolder, new LinkOption[0]) && Files.isDirectory(backupFolder, new LinkOption[0])) {
                return backupFolder;
            }
            log.info("Creating backup folder at {} ...", (Object)backupFolder);
            return Files.createDirectories(backupFolder, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the backup folder:", (Throwable)exception);
            return null;
        }
    }

    public static Path getCacheFolder() {
        Path cacheFolder = Constants.GAME_DIR.resolve("easy_npc").resolve(CACHE_FOLDER_NAME);
        try {
            if (Files.exists(cacheFolder, new LinkOption[0]) && Files.isDirectory(cacheFolder, new LinkOption[0])) {
                return cacheFolder;
            }
            log.info("Creating cache folder at {} ...", (Object)cacheFolder);
            return Files.createDirectories(cacheFolder, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the cache folder:", (Throwable)exception);
            return null;
        }
    }

    public static Path getCustomDataFolder() {
        Path customDataFolder = Constants.CONFIG_DIR.resolve("easy_npc");
        try {
            if (Files.exists(customDataFolder, new LinkOption[0]) && Files.isDirectory(customDataFolder, new LinkOption[0])) {
                return customDataFolder;
            }
            log.info("Creating custom data folder at {} ...", (Object)customDataFolder);
            return Files.createDirectories(customDataFolder, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the custom data folder:", (Throwable)exception);
            return null;
        }
    }

    public static Path getOrCreateBackupFolder(String dataLabel) {
        Path backupFolder = DataFileHandler.getBackupFolder();
        if (backupFolder == null) {
            return null;
        }
        Path backupFolderPath = backupFolder.resolve(dataLabel);
        try {
            if (Files.exists(backupFolderPath, new LinkOption[0]) && Files.isDirectory(backupFolderPath, new LinkOption[0])) {
                return backupFolderPath;
            }
            log.info("Creating backup folder {} at {} ...", (Object)dataLabel, (Object)backupFolder);
            return Files.createDirectories(backupFolderPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the backup folder {}:", (Object)dataLabel, (Object)exception);
            return null;
        }
    }

    public static Path getOrCreateCacheFolder(String dataLabel) {
        Path cacheFolder = DataFileHandler.getCacheFolder();
        if (cacheFolder == null) {
            return null;
        }
        Path cacheFolderPath = cacheFolder.resolve(dataLabel);
        try {
            if (Files.exists(cacheFolderPath, new LinkOption[0]) && Files.isDirectory(cacheFolderPath, new LinkOption[0])) {
                return cacheFolderPath;
            }
            log.info("Creating cache folder {} at {} ...", (Object)dataLabel, (Object)cacheFolder);
            return Files.createDirectories(cacheFolderPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the cache folder {}:", (Object)dataLabel, (Object)exception);
            return null;
        }
    }

    public static Path getOrCreateCustomDataFolder(String dataLabel) {
        Path customDataFolder = DataFileHandler.getCustomDataFolder();
        if (customDataFolder == null) {
            return null;
        }
        Path customDataFolderPath = customDataFolder.resolve(dataLabel);
        try {
            if (Files.exists(customDataFolderPath, new LinkOption[0]) && Files.isDirectory(customDataFolderPath, new LinkOption[0])) {
                return customDataFolderPath;
            }
            log.info("Creating custom data folder {} at {} ...", (Object)dataLabel, (Object)customDataFolder);
            return Files.createDirectories(customDataFolderPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the custom data folder {}:", (Object)dataLabel, (Object)exception);
            return null;
        }
    }

    public static boolean copyResourceFile(MinecraftServer minecraftServer, ResourceLocation resourceLocation, File targetFile) {
        return DataFileHandler.copyResourceFile(minecraftServer, resourceLocation, targetFile, false);
    }

    public static boolean copyResourceFile(MinecraftServer minecraftServer, ResourceLocation resourceLocation, File targetFile, boolean overwriteExisting) {
        if (resourceLocation == null || targetFile == null) {
            log.warn("Cannot copy resource file: resourceLocation or targetFile is null");
            return false;
        }
        if (targetFile.exists() && !overwriteExisting) {
            log.debug("Skipping copy of {} to {} - file already exists", (Object)resourceLocation, (Object)targetFile);
            return true;
        }
        try {
            Optional resources = minecraftServer.getResourceManager().getResource(resourceLocation);
            if (resources.isPresent()) {
                return DataFileHandler.copyResourceToFile((Resource)resources.get(), targetFile);
            }
            log.error("Resource {} not found in resource manager", (Object)resourceLocation);
            return false;
        }
        catch (Exception e) {
            log.error("Failed to load resource {}:", (Object)resourceLocation, (Object)e);
            return false;
        }
    }

    public static boolean copyResourceFile(ResourceLocation resourceLocation, File targetFile) {
        return DataFileHandler.copyResourceFile(resourceLocation, targetFile, false);
    }

    public static boolean copyResourceFile(ResourceLocation resourceLocation, File targetFile, boolean overwriteExisting) {
        if (resourceLocation == null || targetFile == null) {
            log.warn("Cannot copy resource file: resourceLocation or targetFile is null");
            return false;
        }
        if (targetFile.exists() && !overwriteExisting) {
            log.debug("Skipping copy of {} to {} - file already exists", (Object)resourceLocation, (Object)targetFile);
            return true;
        }
        try {
            Optional resources = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
            if (resources.isPresent()) {
                return DataFileHandler.copyResourceToFile((Resource)resources.get(), targetFile);
            }
            log.error("Resource {} not found in resource manager", (Object)resourceLocation);
            return false;
        }
        catch (Exception e) {
            log.error("Failed to load resource {}:", (Object)resourceLocation, (Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean copyResourceToFile(Resource resource, File targetFile) {
        try (InputStream inputStream = resource.open();){
            boolean bl;
            try (FileOutputStream outputStream = new FileOutputStream(targetFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                long totalBytes = 0L;
                while ((bytesRead = inputStream.read(buffer)) > 0) {
                    ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                    totalBytes += (long)bytesRead;
                }
                log.debug("Successfully copied {} bytes to {}", (Object)totalBytes, (Object)targetFile);
                bl = true;
            }
            return bl;
        }
        catch (Exception e) {
            log.error("Failed to copy resource to file {}:", (Object)targetFile, (Object)e);
            return false;
        }
    }

    public static String getFileNameFromResourceLocation(ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        return Paths.get(resourceLocation.getPath(), new String[0]).getFileName().toString();
    }
}

