/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import de.markusbordihn.easynpc.data.configuration.ConfigurationData;
import de.markusbordihn.easynpc.data.skin.variant.ZombieVillagerSkinVariant;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.ZombieVillagerRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ZombieVillagerNPC
extends ZombieVillagerRaw
implements StandardEasyNPC<ZombieVillagerRaw> {
    public static final String ID = "zombie_villager";

    public ZombieVillagerNPC(EntityType<? extends ZombieVillager> entityType, Level level) {
        this(entityType, level, ZombieVillagerSkinVariant.DEFAULT);
    }

    public ZombieVillagerNPC(EntityType<? extends ZombieVillager> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
        this.setInvulnerable(true);
        this.getEntityAttributes().setEnvironmentalAttributes(this.getEntityAttributes().getEnvironmentalAttributes().withCanBreathUnderwater(true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 0.5).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    @Override
    public Component getName() {
        Component component = this.getCustomName();
        if (component != null) {
            return TextUtils.removeAction(component);
        }
        Component professionName = this.getProfessionName();
        Component variantName = this.getSkinVariantTypeName();
        return TextComponent.getText(variantName.getString() + " (" + professionName.getString() + ")");
    }

    @Override
    public boolean hasProfessions() {
        return true;
    }

    @Override
    public ConfigurationData getConfigurationData() {
        return ConfigurationData.STANDARD;
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.ZOMBIE_VILLAGER_AMBIENT);
        soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.ZOMBIE_VILLAGER_HURT);
        soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.ZOMBIE_VILLAGER_DEATH);
        soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.ZOMBIE_VILLAGER_STEP);
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    protected void randomizeReinforcementsChance() {
    }

    protected void registerGoals() {
    }

    protected void addBehaviourGoals() {
    }

    protected boolean isSunSensitive() {
        return false;
    }

    @Override
    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.travel(vec3);
        } else {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
    }
}

