/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.handlers.action.executor;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.scoreboard.ScoreboardOperation;
import de.markusbordihn.easynpc.entity.easynpc.handlers.action.ActionValidator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScoreboardActionExecutor {
    protected static final Logger log = LogManager.getLogger(ScoreboardActionExecutor.class);

    private ScoreboardActionExecutor() {
    }

    public static void execute(ActionDataEntry actionDataEntry, ServerPlayer serverPlayer) {
        Scoreboard scoreboard;
        Objective objective;
        if (!ActionValidator.validateActionData(actionDataEntry, serverPlayer)) {
            log.warn("Failed to execute scoreboard action for player {}: Invalid action data", (Object)serverPlayer.getName().getString());
            return;
        }
        String command = actionDataEntry.command();
        if (!ActionValidator.validateCommand(command)) {
            log.warn("Failed to execute scoreboard action for player {}: No command found in action {}", (Object)serverPlayer.getName().getString(), (Object)actionDataEntry);
            return;
        }
        String[] parts = command.split(":", 3);
        if (parts.length < 2) {
            log.warn("Failed to execute scoreboard action for player {}: Invalid command format '{}'. Expected format: 'operation:scoreboardName:value'", (Object)serverPlayer.getName().getString(), (Object)command);
            return;
        }
        ScoreboardOperation operation = ScoreboardOperation.fromCommandName(parts[0]);
        String scoreboardName = parts[1];
        if (scoreboardName == null || scoreboardName.trim().isEmpty()) {
            log.warn("Failed to execute scoreboard action for player {}: Scoreboard name is empty", (Object)serverPlayer.getName().getString());
            return;
        }
        int value = 1;
        if (parts.length > 2) {
            try {
                value = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                log.warn("Failed to execute scoreboard action for player {}: Invalid value '{}'. Value must be an integer", (Object)serverPlayer.getName().getString(), (Object)parts[2]);
                return;
            }
        }
        if ((objective = (scoreboard = serverPlayer.getScoreboard()).getObjective(scoreboardName)) == null) {
            objective = scoreboard.addObjective(scoreboardName, ObjectiveCriteria.DUMMY, (Component)Component.literal((String)scoreboardName), ObjectiveCriteria.RenderType.INTEGER, false, null);
            if (actionDataEntry.enableDebug()) {
                log.debug("Created new scoreboard objective: {}", (Object)scoreboardName);
            }
        }
        ScoreAccess scoreAccess = scoreboard.getOrCreatePlayerScore((ScoreHolder)serverPlayer, objective);
        switch (operation) {
            case INCREASE: {
                scoreAccess.add(value);
                if (!actionDataEntry.enableDebug()) break;
                log.debug("Increased scoreboard {} with {} for player {} by {}", (Object)scoreboardName, (Object)scoreAccess.get(), (Object)serverPlayer.getName().getString(), (Object)value);
                break;
            }
            case DECREASE: {
                scoreAccess.add(-value);
                if (!actionDataEntry.enableDebug()) break;
                log.debug("Decreased scoreboard {} with {} for player {} by {}", (Object)scoreboardName, (Object)scoreAccess.get(), (Object)serverPlayer.getName().getString(), (Object)value);
                break;
            }
            case SET: {
                scoreAccess.set(value);
                if (!actionDataEntry.enableDebug()) break;
                log.debug("Set scoreboard {} with {} for player {} to {}", (Object)scoreboardName, (Object)scoreAccess.get(), (Object)serverPlayer.getName().getString(), (Object)value);
            }
        }
    }
}

