/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.PathfinderMob;

public interface SkinDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_SKIN_DATA_TAG = "SkinData";

    default public int getEntitySkinScaling() {
        return 30;
    }

    default public String getSkinURL() {
        return this.getSkinDataEntry().url();
    }

    default public UUID getSkinUUID() {
        return this.getSkinDataEntry().uuid();
    }

    default public SkinType getSkinType() {
        return this.getSkinDataEntry().type();
    }

    default public SkinModel getSkinModel() {
        return SkinModel.HUMANOID;
    }

    default public SkinDataEntry getSkinDataEntry() {
        return (SkinDataEntry)this.getSynchedEntityData(SynchedDataIndex.SKIN_DATA);
    }

    default public void setSkinDataEntry(SkinDataEntry skinDataEntry) {
        this.setSynchedEntityData(SynchedDataIndex.SKIN_DATA, skinDataEntry);
    }

    default public void defineSynchedSkinData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.SKIN_DATA, new SkinDataEntry());
    }

    default public void addAdditionalSkinData(CompoundTag compoundTag) {
        CompoundTag skinTag = new CompoundTag();
        this.getSkinDataEntry().write(skinTag);
        compoundTag.put(EASY_NPC_DATA_SKIN_DATA_TAG, (Tag)skinTag);
    }

    default public void readAdditionalSkinData(CompoundTag compoundTag) {
        if (!compoundTag.contains(EASY_NPC_DATA_SKIN_DATA_TAG)) {
            log.warn("No skin data available for {}.", (Object)this);
            return;
        }
        SkinDataEntry skinDataEntry = new SkinDataEntry(compoundTag.getCompound(EASY_NPC_DATA_SKIN_DATA_TAG));
        this.setSkinDataEntry(skinDataEntry);
    }
}

