/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.render.RenderDataEntry;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.PathfinderMob;

public interface RenderDataCapable<E extends PathfinderMob>
extends EasyNPC<E> {
    public static final String DATA_RENDER_DATA_TAG = "RenderData";

    default public void defineSynchedRenderData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.RENDER_DATA, new RenderDataEntry());
    }

    default public RenderDataEntry getRenderDataEntry() {
        return (RenderDataEntry)this.getSynchedEntityData(SynchedDataIndex.RENDER_DATA);
    }

    default public void setRenderData(RenderDataEntry renderData) {
        this.setSynchedEntityData(SynchedDataIndex.RENDER_DATA, renderData, true);
    }

    default public void addAdditionalRenderData(CompoundTag compoundTag) {
        CompoundTag renderTag = new CompoundTag();
        RenderDataEntry renderData = this.getRenderDataEntry();
        if (renderData != null) {
            renderData.write(renderTag);
        }
        compoundTag.put(DATA_RENDER_DATA_TAG, (Tag)renderTag);
    }

    default public void readAdditionalRenderData(CompoundTag compoundTag) {
        if (!compoundTag.contains(DATA_RENDER_DATA_TAG)) {
            return;
        }
        RenderDataEntry renderData = new RenderDataEntry(compoundTag.getCompound(DATA_RENDER_DATA_TAG));
        this.setRenderData(renderData);
    }
}

