/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;

public interface OwnerDataCapable<T extends PathfinderMob>
extends EasyNPC<T>,
OwnableEntity {
    public static final String DATA_OWNER_TAG = "Owner";

    default public void setNPCOwnerUUID(UUID uuid) {
        this.setSynchedEntityData(SynchedDataIndex.OWNER_UUID, Optional.ofNullable(uuid));
    }

    default public boolean hasNPCOwner() {
        return this.getOwnerUUID() != null;
    }

    default public boolean isNPCOwnedBy(LivingEntity livingEntity) {
        return livingEntity != null && this.hasNPCOwner() && livingEntity.getUUID().equals(this.getOwnerUUID());
    }

    default public void setNPCOwner(LivingEntity owner) {
        if (owner != null) {
            this.setNPCOwnerUUID(owner.getUUID());
        } else {
            this.setNPCOwnerUUID(null);
        }
    }

    default public String getNPCOwnerName() {
        LivingEntity owner = this.getOwner();
        return owner == null ? "" : owner.getName().getString();
    }

    default public boolean isNPCOwner(ServerPlayer serverPlayer) {
        return serverPlayer != null && this.isNPCOwner(serverPlayer.getUUID());
    }

    default public boolean isNPCOwner(UUID uuid) {
        return uuid != null && this.hasNPCOwner() && uuid.equals(this.getOwnerUUID());
    }

    default public UUID getOwnerUUID() {
        Optional ownerUUID = (Optional)this.getSynchedEntityData(SynchedDataIndex.OWNER_UUID);
        return ownerUUID.orElse(null);
    }

    default public LivingEntity getOwner() {
        Level level = this.getEntityLevel();
        if (level == null) {
            return null;
        }
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : level.getPlayerByUUID(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    default public void defineSynchedOwnerData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.OWNER_UUID, Optional.empty());
    }

    default public void addAdditionalOwnerData(CompoundTag compoundTag) {
        if (this.getOwnerUUID() != null) {
            compoundTag.putUUID(DATA_OWNER_TAG, this.getOwnerUUID());
        }
    }

    default public void readAdditionalOwnerData(CompoundTag compoundTag) {
        if (compoundTag.hasUUID(DATA_OWNER_TAG)) {
            UUID uuid = compoundTag.getUUID(DATA_OWNER_TAG);
            this.setNPCOwnerUUID(uuid);
        }
    }
}

