/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelAnimationBehavior;
import de.markusbordihn.easynpc.data.model.ModelAnimationData;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.PathfinderMob;

public interface ModelAnimationDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final String EASY_NPC_DATA_ANIMATION_DATA_TAG = "AnimationData";

    default public ModelAnimationData getModelAnimationData() {
        ModelAnimationData animationData = (ModelAnimationData)this.getSynchedEntityData(SynchedDataIndex.MODEL_ANIMATION);
        if (animationData == null) {
            animationData = new ModelAnimationData();
            this.setModelAnimationData(animationData);
        }
        return animationData;
    }

    default public void setModelAnimationData(ModelAnimationData animationData) {
        if (animationData != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_ANIMATION, animationData);
        }
    }

    default public ModelAnimationBehavior getModelAnimationBehavior() {
        return this.getModelAnimationData().behavior();
    }

    default public void setModelAnimationBehavior(ModelAnimationBehavior behavior) {
        this.setModelAnimationData(new ModelAnimationData(behavior));
    }

    default public void defineSynchedModelAnimationData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_ANIMATION, new ModelAnimationData());
    }

    default public void addAdditionalModelAnimationData(CompoundTag compoundTag) {
        ModelAnimationData animationData = this.getModelAnimationData();
        if (animationData != null && animationData.hasChanged()) {
            compoundTag.put(EASY_NPC_DATA_ANIMATION_DATA_TAG, (Tag)animationData.save());
        }
    }

    default public void readAdditionalModelAnimationData(CompoundTag compoundTag) {
        if (!compoundTag.contains(EASY_NPC_DATA_ANIMATION_DATA_TAG)) {
            return;
        }
        CompoundTag animationDataTag = compoundTag.getCompound(EASY_NPC_DATA_ANIMATION_DATA_TAG);
        ModelAnimationData animationData = new ModelAnimationData(animationDataTag);
        this.setModelAnimationData(animationData);
    }
}

