/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.test;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.markusbordihn.easynpc.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record TestItemData(String quote, int numberValue, int powerLevel, int usageCounter) {
    public static final String ID = "test_item_data";
    public static final String DEFAULT_QUOTE = "This is a test quote to verify custom data!";
    public static final int DEFAULT_NUMBER_VALUE = 42;
    public static final int DEFAULT_POWER_LEVEL = 9001;
    public static final int DEFAULT_USAGE_COUNTER = 0;
    public static final TestItemData DEFAULT = new TestItemData("This is a test quote to verify custom data!", 42, 9001, 0);
    public static final Codec<TestItemData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("quote").forGetter(TestItemData::quote), (App)Codec.INT.fieldOf("numberValue").forGetter(TestItemData::numberValue), (App)Codec.INT.fieldOf("powerLevel").forGetter(TestItemData::powerLevel), (App)Codec.INT.fieldOf("usageCounter").forGetter(TestItemData::usageCounter)).apply((Applicative)instance, TestItemData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TestItemData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, TestItemData::quote, (StreamCodec)ByteBufCodecs.INT, TestItemData::numberValue, (StreamCodec)ByteBufCodecs.INT, TestItemData::powerLevel, (StreamCodec)ByteBufCodecs.INT, TestItemData::usageCounter, TestItemData::new);

    public static boolean has(ItemStack itemStack) {
        return itemStack != null && !itemStack.isEmpty() && itemStack.has(DataComponents.TEST_ITEM_DATA);
    }

    public static TestItemData get(ItemStack itemStack) {
        if (!TestItemData.has(itemStack)) {
            return null;
        }
        return (TestItemData)itemStack.get(DataComponents.TEST_ITEM_DATA);
    }

    public static ItemStack set(Item item, TestItemData testItemData) {
        return TestItemData.set(new ItemStack((ItemLike)item), testItemData);
    }

    public static ItemStack set(ItemStack itemStack, TestItemData testItemData) {
        if (itemStack == null || itemStack.isEmpty() || testItemData == null) {
            return null;
        }
        itemStack.set(DataComponents.TEST_ITEM_DATA, (Object)testItemData);
        return itemStack;
    }

    public TestItemData withIncrementedUsageCounter() {
        return new TestItemData(this.quote, this.numberValue, this.powerLevel, this.usageCounter + 1);
    }
}

