/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.render;

import de.markusbordihn.easynpc.data.render.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public record RenderDataEntry(RenderType renderType, EntityType<? extends Entity> renderEntityType) {
    static final String DATA_RENDER_TYPE_TAG = "Type";
    static final String DATA_RENDER_ENTITY_TYPE_TAG = "EntityType";
    public static final StreamCodec<RegistryFriendlyByteBuf, RenderDataEntry> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, RenderDataEntry>(){

        public RenderDataEntry decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            return new RenderDataEntry(registryFriendlyByteBuf.readNbt());
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, RenderDataEntry renderDataEntry) {
            registryFriendlyByteBuf.writeNbt((Tag)renderDataEntry.createTag());
        }
    };

    public RenderDataEntry() {
        this(RenderType.DEFAULT, null);
    }

    public RenderDataEntry(CompoundTag compoundTag) {
        this(compoundTag.contains(DATA_RENDER_TYPE_TAG) ? RenderType.get(compoundTag.getString(DATA_RENDER_TYPE_TAG)) : RenderType.DEFAULT, compoundTag.contains(DATA_RENDER_ENTITY_TYPE_TAG) ? (EntityType)EntityType.byString((String)compoundTag.getString(DATA_RENDER_ENTITY_TYPE_TAG)).orElse(null) : null);
    }

    public RenderDataEntry withRenderType(RenderType renderType) {
        return new RenderDataEntry(renderType, renderType == RenderType.DEFAULT ? null : this.renderEntityType);
    }

    public RenderDataEntry withRenderEntityType(EntityType<? extends Entity> renderEntityType) {
        return new RenderDataEntry(renderEntityType != null ? RenderType.CUSTOM_ENTITY : RenderType.DEFAULT, renderEntityType);
    }

    public RenderDataEntry create(CompoundTag compoundTag) {
        return new RenderDataEntry(compoundTag);
    }

    public CompoundTag write(CompoundTag compoundTag) {
        if (this.renderType != RenderType.DEFAULT) {
            compoundTag.putString(DATA_RENDER_TYPE_TAG, this.renderType.name());
        }
        if (this.renderEntityType != null && this.renderEntityType.canSerialize()) {
            ResourceLocation entityTypeResourceLocation = EntityType.getKey(this.renderEntityType);
            compoundTag.putString(DATA_RENDER_ENTITY_TYPE_TAG, entityTypeResourceLocation.toString());
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.write(new CompoundTag());
    }

    public CompoundTag save(CompoundTag compoundTag) {
        return this.write(compoundTag);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public EntityType<? extends Entity> getRenderEntityType() {
        return this.renderEntityType;
    }
}

