/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.render;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.skin.SkinType;
import java.util.UUID;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;

public record EntityRenderOverrides(CustomRotation rootRotation, CustomScale rootScale, ModelPose modelPose, Pose entityPose, Boolean invisible, Boolean hideNameTag, RenderType renderType, EntityType<?> renderEntityType, SkinType skinType, UUID skinUUID, Enum<?> variant, Profession profession) {
    public static final EntityRenderOverrides NONE = new EntityRenderOverrides(null, null, null, null, null, null, null, null, null, null, null, null);
    public static final EntityRenderOverrides HIDE_NAME_TAG = NONE.withHideNameTag(true);
    public static final EntityRenderOverrides RESET_ROOT = NONE.withRootRotation(new CustomRotation(0.0f, 0.0f, 0.0f)).withRootScale(new CustomScale(1.0f, 1.0f, 1.0f));
    public static final EntityRenderOverrides HIDE_NAME_TAG_RESET_ROOT = RESET_ROOT.withHideNameTag(true);

    public static EntityRenderOverrides withSkin(SkinType skinType, UUID skinUUID) {
        return NONE.withHideNameTag(true).withSkinType(skinType).withSkinUUID(skinUUID).withRootScale(new CustomScale(1.0f, 1.0f, 1.0f));
    }

    public static EntityRenderOverrides withVariant(Enum<?> variant, Profession profession) {
        return NONE.withHideNameTag(true).withSkinType(SkinType.DEFAULT).withVariant(variant).withProfession(profession).withRootScale(new CustomScale(1.0f, 1.0f, 1.0f));
    }

    public static EntityRenderOverrides withCustomModel(RenderType renderType, EntityType<?> entityType) {
        return NONE.withRenderType(renderType, entityType);
    }

    public EntityRenderOverrides withRootRotation(CustomRotation rotation) {
        return new EntityRenderOverrides(rotation, this.rootScale, this.modelPose, this.entityPose, this.invisible, this.hideNameTag, this.renderType, this.renderEntityType, this.skinType, this.skinUUID, this.variant, this.profession);
    }

    public EntityRenderOverrides withRootScale(CustomScale scale) {
        return new EntityRenderOverrides(this.rootRotation, scale, this.modelPose, this.entityPose, this.invisible, this.hideNameTag, this.renderType, this.renderEntityType, this.skinType, this.skinUUID, this.variant, this.profession);
    }

    public EntityRenderOverrides withModelPose(ModelPose modelPose) {
        return new EntityRenderOverrides(this.rootRotation, this.rootScale, modelPose, this.entityPose, this.invisible, this.hideNameTag, this.renderType, this.renderEntityType, this.skinType, this.skinUUID, this.variant, this.profession);
    }

    public EntityRenderOverrides withEntityPose(Pose entityPose) {
        return new EntityRenderOverrides(this.rootRotation, this.rootScale, this.modelPose, entityPose, this.invisible, this.hideNameTag, this.renderType, this.renderEntityType, this.skinType, this.skinUUID, this.variant, this.profession);
    }

    public EntityRenderOverrides withInvisible(boolean invisible) {
        return new EntityRenderOverrides(this.rootRotation, this.rootScale, this.modelPose, this.entityPose, invisible, this.hideNameTag, this.renderType, this.renderEntityType, this.skinType, this.skinUUID, this.variant, this.profession);
    }

    public EntityRenderOverrides withHideNameTag(boolean hide) {
        return new EntityRenderOverrides(this.rootRotation, this.rootScale, this.modelPose, this.entityPose, this.invisible, hide, this.renderType, this.renderEntityType, this.skinType, this.skinUUID, this.variant, this.profession);
    }

    public EntityRenderOverrides withRenderType(RenderType renderType, EntityType<?> entityType) {
        return new EntityRenderOverrides(this.rootRotation, this.rootScale, this.modelPose, this.entityPose, this.invisible, this.hideNameTag, renderType, entityType, this.skinType, this.skinUUID, this.variant, this.profession);
    }

    public EntityRenderOverrides withSkinType(SkinType skinType) {
        return new EntityRenderOverrides(this.rootRotation, this.rootScale, this.modelPose, this.entityPose, this.invisible, this.hideNameTag, this.renderType, this.renderEntityType, skinType, this.skinUUID, this.variant, this.profession);
    }

    public EntityRenderOverrides withSkinUUID(UUID skinUUID) {
        return new EntityRenderOverrides(this.rootRotation, this.rootScale, this.modelPose, this.entityPose, this.invisible, this.hideNameTag, this.renderType, this.renderEntityType, this.skinType, skinUUID, this.variant, this.profession);
    }

    public EntityRenderOverrides withVariant(Enum<?> variant) {
        return new EntityRenderOverrides(this.rootRotation, this.rootScale, this.modelPose, this.entityPose, this.invisible, this.hideNameTag, this.renderType, this.renderEntityType, this.skinType, this.skinUUID, variant, this.profession);
    }

    public EntityRenderOverrides withProfession(Profession profession) {
        return new EntityRenderOverrides(this.rootRotation, this.rootScale, this.modelPose, this.entityPose, this.invisible, this.hideNameTag, this.renderType, this.renderEntityType, this.skinType, this.skinUUID, this.variant, profession);
    }
}

