/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.execution;

import de.markusbordihn.easynpc.data.execution.ExecutionData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public record ExecutionTrackerData(Map<UUID, Map<UUID, ExecutionData>> trackingData) {
    public static final String DATA_PLAYERS_TAG = "Players";
    public static final String DATA_PLAYER_UUID_TAG = "PlayerUUID";
    public static final String DATA_TARGETS_TAG = "Targets";
    public static final String DATA_TARGET_UUID_TAG = "TargetUUID";

    public ExecutionTrackerData() {
        this(new HashMap<UUID, Map<UUID, ExecutionData>>());
    }

    public ExecutionTrackerData(CompoundTag tag) {
        this(ExecutionTrackerData.loadFromTag(tag));
    }

    private static Map<UUID, Map<UUID, ExecutionData>> loadFromTag(CompoundTag compoundTag) {
        HashMap<UUID, Map<UUID, ExecutionData>> data = new HashMap<UUID, Map<UUID, ExecutionData>>();
        ListTag playersTag = compoundTag.getList(DATA_PLAYERS_TAG, 10);
        for (int i = 0; i < playersTag.size(); ++i) {
            CompoundTag playerTag = playersTag.getCompound(i);
            UUID playerUUID = playerTag.getUUID(DATA_PLAYER_UUID_TAG);
            HashMap<UUID, ExecutionData> playerData = new HashMap<UUID, ExecutionData>();
            ListTag targetsTag = playerTag.getList(DATA_TARGETS_TAG, 10);
            for (int j = 0; j < targetsTag.size(); ++j) {
                CompoundTag targetTag = targetsTag.getCompound(j);
                playerData.put(targetTag.getUUID(DATA_TARGET_UUID_TAG), new ExecutionData(targetTag));
            }
            data.put(playerUUID, playerData);
        }
        return data;
    }

    public CompoundTag save(CompoundTag compoundTag) {
        ListTag playersTag = new ListTag();
        for (Map.Entry<UUID, Map<UUID, ExecutionData>> playerEntry : this.trackingData.entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.putUUID(DATA_PLAYER_UUID_TAG, playerEntry.getKey());
            ListTag targetsTag = new ListTag();
            for (Map.Entry<UUID, ExecutionData> targetEntry : playerEntry.getValue().entrySet()) {
                CompoundTag targetTag = new CompoundTag();
                targetTag.putUUID(DATA_TARGET_UUID_TAG, targetEntry.getKey());
                targetEntry.getValue().save(targetTag);
                targetsTag.add((Object)targetTag);
            }
            playerTag.put(DATA_TARGETS_TAG, (Tag)targetsTag);
            playersTag.add((Object)playerTag);
        }
        compoundTag.put(DATA_PLAYERS_TAG, (Tag)playersTag);
        return compoundTag;
    }

    public CompoundTag save() {
        return this.save(new CompoundTag());
    }
}

