/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

public enum ConditionOperationType {
    NONE,
    EQUALS,
    NOT_EQUALS,
    GREATER_THAN,
    GREATER_THAN_OR_EQUALS,
    LESS_THAN,
    LESS_THAN_OR_EQUALS;


    public static ConditionOperationType get(String operationType) {
        if (operationType == null || operationType.isEmpty()) {
            return NONE;
        }
        try {
            return ConditionOperationType.valueOf(operationType);
        }
        catch (IllegalArgumentException e) {
            return NONE;
        }
    }

    public String getSymbol() {
        return switch (this.ordinal()) {
            case 1 -> "==";
            case 2 -> "!=";
            case 3 -> ">";
            case 4 -> ">=";
            case 5 -> "<";
            case 6 -> "<=";
            default -> "";
        };
    }

    public boolean evaluate(int value1, int value2) {
        return switch (this.ordinal()) {
            case 1 -> {
                if (value1 == value2) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (value1 != value2) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (value1 > value2) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (value1 >= value2) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (value1 < value2) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (value1 <= value2) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

