/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.client.texture.TextureNameHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureRegistrationHelper {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String LOG_PREFIX = "[Texture Registration Helper]";

    private TextureRegistrationHelper() {
    }

    public static ResourceLocation registerTexture(TextureModelKey textureModelKey, NativeImage nativeImage) {
        DynamicTexture dynamicTexture;
        Minecraft client = Minecraft.getInstance();
        TextureManager textureManager = client.getTextureManager();
        try {
            dynamicTexture = new DynamicTexture(nativeImage);
        }
        catch (Exception exception) {
            log.error("{} Unable to create dynamic texture for {}:", (Object)LOG_PREFIX, (Object)textureModelKey, (Object)exception);
            nativeImage.close();
            return null;
        }
        String resourceName = TextureNameHelper.getResourceName(textureModelKey);
        ResourceLocation resourceLocation = textureManager.register(resourceName, dynamicTexture);
        log.info("{} Registered texture {} with image {} with {}.", (Object)LOG_PREFIX, (Object)textureModelKey, (Object)nativeImage, (Object)resourceLocation);
        return resourceLocation;
    }
}

