/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import java.util.Objects;
import java.util.UUID;

public record TextureModelKey(UUID uuid, SkinModel skinModel, String resourceName) {
    public TextureModelKey(UUID uuid, SkinModel skinModel) {
        this(uuid, skinModel, "");
    }

    public String getSubType() {
        return this.skinModel != null ? this.skinModel.name() : "";
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public SkinModel getSkinModel() {
        return this.skinModel;
    }

    public String getResourceName() {
        return this.resourceName != null ? this.resourceName : "";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TextureModelKey)) {
            return false;
        }
        TextureModelKey other = (TextureModelKey)obj;
        return Objects.equals(this.uuid, other.uuid) && Objects.equals(this.getSubType(), other.getSubType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.uuid, this.getSubType());
    }

    @Override
    public String toString() {
        return "TextureModelKey{uuid=" + String.valueOf(this.uuid) + ", skinModel=" + String.valueOf((Object)this.skinModel) + ", subType='" + this.getSubType() + "', resourceName='" + this.resourceName + "'}";
    }
}

