/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import de.markusbordihn.easynpc.client.texture.TextureImageLoader;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.client.texture.TextureRegistrationHelper;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureCacheManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String LOG_PREFIX = "[Texture Cache Manager]";
    private static final String FILE_EXTENSION_PNG = ".png";

    private TextureCacheManager() {
    }

    public static ResourceLocation getCachedTexture(TextureModelKey textureModelKey, Path targetDirectory) {
        String fileName = String.format("%s.png", textureModelKey.getUUID());
        File file = targetDirectory.resolve(fileName).toFile();
        if (file.exists()) {
            NativeImage nativeImage;
            log.info("{} Found texture file in cache, will re-used file {} for {}", (Object)LOG_PREFIX, (Object)file, (Object)textureModelKey);
            NativeImage nativeImage2 = nativeImage = textureModelKey.getSkinModel() == SkinModel.HUMANOID || textureModelKey.getSkinModel() == SkinModel.HUMANOID_SLIM ? TextureImageLoader.getNativePlayerImage(file) : TextureImageLoader.getNativeImage(file);
            if (nativeImage == null) {
                return null;
            }
            return TextureRegistrationHelper.registerTexture(textureModelKey, nativeImage);
        }
        return null;
    }

    public static ResourceLocation searchCachedTexture(TextureModelKey textureModelKey, Path targetDirectory) {
        ResourceLocation resourceLocation = TextureCacheManager.getCachedTexture(textureModelKey, targetDirectory);
        if (resourceLocation != null) {
            return resourceLocation;
        }
        UUID textureUUID = textureModelKey.getUUID();
        File[] files = targetDirectory.toFile().listFiles();
        if (files == null) {
            log.warn("{} Unable to list files in cache directory {}", (Object)LOG_PREFIX, (Object)targetDirectory);
            return null;
        }
        for (File file : files) {
            NativeImage nativeImage;
            String filename;
            UUID uuid;
            if (file == null || !textureUUID.equals(uuid = TextureCacheManager.getUUIDFromFilename(filename = file.getName()))) continue;
            NativeImage nativeImage2 = nativeImage = textureModelKey.getSkinModel() == SkinModel.HUMANOID || textureModelKey.getSkinModel() == SkinModel.HUMANOID_SLIM ? TextureImageLoader.getNativePlayerImage(file) : TextureImageLoader.getNativeImage(file);
            if (nativeImage == null) {
                log.error("{} Unable to load native image from cached texture file {} for {}", (Object)LOG_PREFIX, (Object)file, (Object)textureModelKey);
                return null;
            }
            ResourceLocation textureResourceLocation = TextureRegistrationHelper.registerTexture(textureModelKey, nativeImage);
            if (textureResourceLocation != null) {
                log.info("{} Registered cached texture file {} for {} with {}", (Object)LOG_PREFIX, (Object)file, (Object)textureModelKey, (Object)textureResourceLocation);
            } else {
                log.error("{} Unable to register cached texture file {} for {}", (Object)LOG_PREFIX, (Object)file, (Object)textureModelKey);
            }
            return textureResourceLocation;
        }
        log.warn("{} Unable to find any cached texture file for {} in {}", (Object)LOG_PREFIX, (Object)textureModelKey, (Object)targetDirectory);
        return null;
    }

    public static TextureModelKey getTextureModelKey(SkinModel skinModel, File textureFile) {
        String filename = textureFile.getName();
        UUID uuid = TextureCacheManager.getUUIDFromFilename(filename);
        if (uuid == null) {
            log.error("{} Unable to get UUID for {} and texture file {}!", (Object)LOG_PREFIX, (Object)skinModel, (Object)filename);
            return null;
        }
        return new TextureModelKey(uuid, skinModel, filename);
    }

    public static UUID getUUIDFromFilename(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        if (!fileName.endsWith(FILE_EXTENSION_PNG)) {
            log.error("{} Unable to get UUID from invalid file name {}!", (Object)LOG_PREFIX, (Object)fileName);
            return null;
        }
        try {
            return UUID.fromString(fileName.substring(0, fileName.indexOf(46)));
        }
        catch (IllegalArgumentException e) {
            return UUID.nameUUIDFromBytes(fileName.getBytes());
        }
    }
}

