/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.AsyncTextureLoader;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.data.texture.TextureFailureInfo;
import de.markusbordihn.easynpc.data.texture.TextureFailureType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.io.RemoteSkinDataFiles;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final Map<TextureModelKey, ResourceLocation> textureCache = new ConcurrentHashMap<TextureModelKey, ResourceLocation>();
    private static final Map<TextureModelKey, SkinType> textureSkinTypeCache = new ConcurrentHashMap<TextureModelKey, SkinType>();
    private static final Map<TextureModelKey, String> textureSkinURLCache = new ConcurrentHashMap<TextureModelKey, String>();
    private static final Map<UUID, Long> textureReloadProtection = new ConcurrentHashMap<UUID, Long>();
    private static final Map<TextureModelKey, TextureFailureInfo> permanentFailures = new ConcurrentHashMap<TextureModelKey, TextureFailureInfo>();
    private static final Map<TextureModelKey, Integer> retryAttempts = new ConcurrentHashMap<TextureModelKey, Integer>();
    private static final String LOG_PREFIX = "[Remote Texture Manager] ";
    private static final long BASE_RETRY_DELAY = 60000L;
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final long CACHE_CLEANUP_INTERVAL = 600000L;
    private static volatile long lastCleanup = System.currentTimeMillis();

    private RemoteTextureManager() {
    }

    public static void markPermanentFailure(TextureModelKey key, TextureFailureType type, String details, String url) {
        if (type.isPermanent()) {
            permanentFailures.put(key, new TextureFailureInfo(type, details, url));
            log.warn("{} Marked texture {} as permanently failed: {} - {}", (Object)LOG_PREFIX, (Object)key, (Object)type, (Object)details);
        }
    }

    public static boolean hasPermanentFailure(TextureModelKey key) {
        return permanentFailures.containsKey(key);
    }

    public static void clearPermanentFailure(TextureModelKey key) {
        if (permanentFailures.remove(key) != null) {
            retryAttempts.remove(key);
            textureReloadProtection.remove(key.getUUID());
            log.info("{} Cleared permanent failure for {}", (Object)LOG_PREFIX, (Object)key);
        }
    }

    public static void clearAllPermanentFailures() {
        int count = permanentFailures.size();
        permanentFailures.clear();
        retryAttempts.clear();
        log.info("{} Cleared {} permanent failures", (Object)LOG_PREFIX, (Object)count);
    }

    private static long calculateRetryDelay(int attempts) {
        if (attempts >= 3) {
            return Long.MAX_VALUE;
        }
        return 60000L * (long)Math.pow(2.0, attempts);
    }

    private static void cleanupOldEntries() {
        long now = System.currentTimeMillis();
        if (now - lastCleanup < 600000L) {
            return;
        }
        textureReloadProtection.entrySet().removeIf(entry -> now - (Long)entry.getValue() > 300000L);
        retryAttempts.entrySet().removeIf(entry -> textureCache.containsKey(entry.getKey()));
        lastCleanup = now;
    }

    public static Set<UUID> getTextureCacheKeys(SkinModel skinModel) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (TextureModelKey textureModelKey : textureCache.keySet()) {
            if (!skinModel.equals((Object)textureModelKey.getSkinModel()) || !RemoteTextureManager.hasTextureSkinData(textureModelKey)) continue;
            hashSet.add(textureModelKey.getUUID());
        }
        return hashSet;
    }

    public static String getTextureSkinURL(TextureModelKey textureModelKey) {
        return textureSkinURLCache.get(textureModelKey);
    }

    public static SkinType getTextureSkinType(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.get(textureModelKey);
    }

    public static boolean hasTextureSkinData(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.containsKey(textureModelKey) && textureSkinURLCache.containsKey(textureModelKey);
    }

    public static ResourceLocation getOrCreateTextureWithDefault(SkinDataCapable<?> skinData, ResourceLocation defaultResourceLocation) {
        RemoteTextureManager.cleanupOldEntries();
        UUID skinUUID = skinData.getSkinUUID();
        if (skinUUID.equals(Constants.BLANK_UUID)) {
            return defaultResourceLocation;
        }
        TextureModelKey textureModelKey = new TextureModelKey(skinUUID, skinData.getSkinModel());
        ResourceLocation resourceLocation = textureCache.get(textureModelKey);
        String skinURL = skinData.getSkinURL();
        if (resourceLocation != null) {
            if (!RemoteTextureManager.hasTextureSkinData(textureModelKey)) {
                textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
                textureSkinURLCache.put(textureModelKey, skinURL);
            }
            return resourceLocation;
        }
        ResourceLocation createdResourceLocation = RemoteTextureManager.createTexture(textureModelKey, skinData, skinURL);
        return createdResourceLocation != null ? createdResourceLocation : defaultResourceLocation;
    }

    private static ResourceLocation createTexture(TextureModelKey textureModelKey, SkinDataCapable<?> skinData, String skinURL) {
        if (RemoteTextureManager.hasPermanentFailure(textureModelKey)) {
            return null;
        }
        UUID skinUUID = textureModelKey.getUUID();
        long currentTime = System.currentTimeMillis();
        int attempts = retryAttempts.compute(textureModelKey, (key, current) -> {
            int currentAttempts;
            int n = currentAttempts = current == null ? 0 : current;
            if (currentAttempts >= 3) {
                return currentAttempts;
            }
            return currentAttempts + 1;
        });
        if (attempts > 3) {
            RemoteTextureManager.markPermanentFailure(textureModelKey, TextureFailureType.MAX_RETRIES_EXCEEDED, "Maximum retry attempts exceeded", skinURL);
            return null;
        }
        long requiredDelay = RemoteTextureManager.calculateRetryDelay(attempts - 1);
        Long lastAttempt = textureReloadProtection.get(skinUUID);
        if (lastAttempt != null && currentTime - lastAttempt < requiredDelay) {
            return null;
        }
        Long existingAttempt = textureReloadProtection.putIfAbsent(skinUUID, currentTime);
        if (existingAttempt != null && currentTime - existingAttempt < requiredDelay) {
            return null;
        }
        SkinModel skinModel = skinData.getSkinModel();
        Path textureDataFolder = RemoteSkinDataFiles.getRemoteSkinDataFolder(skinModel);
        if (textureDataFolder == null) {
            return null;
        }
        ResourceLocation localTextureCache = TextureManager.getCachedTexture(textureModelKey, textureDataFolder);
        if (localTextureCache != null) {
            textureCache.put(textureModelKey, localTextureCache);
            textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            textureSkinURLCache.put(textureModelKey, skinURL);
            return localTextureCache;
        }
        AsyncTextureLoader.loadTextureAsync(textureModelKey, skinURL, textureDataFolder).thenAccept(resourceLocation -> {
            if (resourceLocation != null) {
                textureCache.put(textureModelKey, (ResourceLocation)resourceLocation);
                textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
                textureSkinURLCache.put(textureModelKey, skinURL);
                retryAttempts.remove(textureModelKey);
            } else {
                log.error("{} Unable to load remote texture {} ({}) from {}!", (Object)LOG_PREFIX, (Object)textureModelKey, (Object)skinURL, (Object)textureDataFolder);
            }
        });
        return null;
    }

    public static void registerTexture(SkinModel skinModel, File textureFile) {
        RemoteTextureManager.registerTexture(TextureManager.getTextureModelKey(skinModel, textureFile), textureFile);
    }

    public static void registerTexture(TextureModelKey textureModelKey, File textureFile) {
        ResourceLocation resourceLocation = TextureManager.addCustomTexture(textureModelKey, textureFile);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
        }
    }

    public static void clearTextureCache() {
        textureReloadProtection.clear();
        textureCache.clear();
        textureSkinTypeCache.clear();
        textureSkinURLCache.clear();
        permanentFailures.clear();
        retryAttempts.clear();
    }
}

