/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.client.texture.TextureCacheManager;
import de.markusbordihn.easynpc.client.texture.TextureErrorHandler;
import de.markusbordihn.easynpc.client.texture.TextureImageLoader;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.client.texture.TextureNameHelper;
import de.markusbordihn.easynpc.client.texture.TextureRegistrationHelper;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.texture.TextureFailureType;
import de.markusbordihn.easynpc.validator.ImageValidator;
import de.markusbordihn.easynpc.validator.UrlValidator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteTextureLoader {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String LOG_PREFIX = "[Remote Texture Loader]";
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 30000;
    private static final long MAX_DOWNLOAD_SIZE = 0x500000L;

    private RemoteTextureLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceLocation loadRemoteTexture(TextureModelKey textureModelKey, String remoteUrl, Path targetDirectory) {
        String error;
        if (!UrlValidator.isValidUrl(remoteUrl)) {
            String error2 = "Invalid URL format or forbidden extension";
            TextureErrorHandler.urlLoadErrorMessage(textureModelKey, remoteUrl, error2);
            RemoteTextureManager.markPermanentFailure(textureModelKey, TextureFailureType.URL_INVALID, error2, remoteUrl);
            return null;
        }
        ResourceLocation cachedTexture = TextureCacheManager.getCachedTexture(textureModelKey, targetDirectory);
        if (cachedTexture != null) {
            log.info("{} Found downloaded file in cache, will re-used {} for {}", (Object)LOG_PREFIX, (Object)cachedTexture, (Object)remoteUrl);
            return cachedTexture;
        }
        log.warn("{} Starting download of remote texture from {} for {}", (Object)LOG_PREFIX, (Object)remoteUrl, (Object)textureModelKey);
        HttpURLConnection connection = null;
        NativeImage nativeImage = null;
        try {
            URL remoteImageURL = new URL(remoteUrl);
            connection = (HttpURLConnection)remoteImageURL.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(30000);
            long contentLength = connection.getContentLengthLong();
            if (contentLength > 0x500000L) {
                String error3 = String.format("File too large: %d bytes (max %d bytes)", contentLength, 0x500000L);
                TextureErrorHandler.urlLoadErrorMessage(textureModelKey, remoteUrl, error3);
                RemoteTextureManager.markPermanentFailure(textureModelKey, TextureFailureType.FILE_TOO_LARGE, error3, remoteUrl);
                ResourceLocation resourceLocation = null;
                return resourceLocation;
            }
            int responseCode = connection.getResponseCode();
            if (responseCode == 301 || responseCode == 302) {
                String redirectUrl = connection.getHeaderField("Location");
                log.info("{} Following redirect from {} > {}", (Object)LOG_PREFIX, (Object)remoteUrl, (Object)redirectUrl);
                connection.disconnect();
                remoteImageURL = new URL(redirectUrl);
                connection = (HttpURLConnection)remoteImageURL.openConnection();
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(30000);
                responseCode = connection.getResponseCode();
                remoteUrl = redirectUrl;
            }
            if (responseCode != 200) {
                String error4 = "HTTP " + responseCode + ": " + connection.getResponseMessage();
                TextureErrorHandler.urlLoadErrorMessage(textureModelKey, remoteUrl, error4);
                RemoteTextureManager.markPermanentFailure(textureModelKey, TextureFailureType.NETWORK_ERROR, error4, remoteUrl);
                ResourceLocation resourceLocation = null;
                return resourceLocation;
            }
            try (InputStream inputStream = connection.getInputStream();){
                nativeImage = NativeImage.read((InputStream)inputStream);
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            String error5 = exception.getClass().getSimpleName() + ": " + exception.getMessage();
            TextureErrorHandler.urlLoadErrorMessage(textureModelKey, remoteUrl, error5);
            RemoteTextureManager.markPermanentFailure(textureModelKey, TextureFailureType.NETWORK_ERROR, error5, remoteUrl);
            ResourceLocation resourceLocation = null;
            return resourceLocation;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (nativeImage == null) {
            error = "Failed to decode image";
            TextureErrorHandler.processingErrorMessage(textureModelKey, remoteUrl, error);
            RemoteTextureManager.markPermanentFailure(textureModelKey, TextureFailureType.DECODING_ERROR, error, remoteUrl);
            return null;
        }
        if (!ImageValidator.isValidImage(nativeImage)) {
            error = String.format("Invalid image dimensions: %dx%d (expected 64x64, 64x32, or multiples of 32 >= 32x32)", nativeImage.getWidth(), nativeImage.getHeight());
            TextureErrorHandler.processingErrorMessage(textureModelKey, remoteUrl, error);
            RemoteTextureManager.markPermanentFailure(textureModelKey, TextureFailureType.INVALID_IMAGE_SIZE, error, remoteUrl);
            nativeImage.close();
            return null;
        }
        if ((textureModelKey.getSkinModel() == SkinModel.HUMANOID || textureModelKey.getSkinModel() == SkinModel.HUMANOID_SLIM) && nativeImage.getWidth() == 64 && nativeImage.getHeight() == 32) {
            log.info("{} Processing legacy image from 64x32 to 64x64 for {}", (Object)LOG_PREFIX, (Object)textureModelKey);
            nativeImage = TextureImageLoader.getNativeImageFromLegacyImage(nativeImage);
        }
        UUID uuid = textureModelKey.getUUID();
        File cacheFile = targetDirectory.resolve(TextureNameHelper.getFileName(uuid)).toFile();
        try {
            nativeImage.writeToFile(cacheFile.toPath());
            log.info("{} Cached downloaded texture as {} for {}", (Object)LOG_PREFIX, (Object)cacheFile, (Object)textureModelKey);
        }
        catch (IOException exception) {
            log.warn("{} Unable to cache texture to file {}: {}", (Object)LOG_PREFIX, (Object)cacheFile, (Object)exception.getMessage());
        }
        NativeImage finalImage = nativeImage;
        CompletableFuture registrationFuture = new CompletableFuture();
        Minecraft.getInstance().execute(() -> {
            try {
                ResourceLocation resourceLocation = TextureRegistrationHelper.registerTexture(textureModelKey, finalImage);
                registrationFuture.complete(resourceLocation);
            }
            catch (Exception e) {
                log.error("{} Failed to register texture on main thread: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
                finalImage.close();
                registrationFuture.completeExceptionally(e);
            }
        });
        try {
            return (ResourceLocation)registrationFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("{} Timeout or error waiting for texture registration: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
            nativeImage.close();
            return null;
        }
    }
}

