/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.util;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public final class ContainerUtil {
    private ContainerUtil() {
    }

    public static CompoundTag write(Container container, HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            tag.put(ContainerUtil.getSlotKey(i), stack.save(provider));
        }
        return tag;
    }

    public static void read(CompoundTag tag, Container container, HolderLookup.Provider provider) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ContainerUtil.readSlot(tag, container, i, provider);
        }
    }

    private static void readSlot(CompoundTag tag, Container container, int i, HolderLookup.Provider provider) {
        if (!ContainerUtil.hasItemInSlot(tag, i)) {
            return;
        }
        ItemStack stack = ContainerUtil.getItemInSlot(tag, i, provider);
        if (stack.isEmpty()) {
            return;
        }
        container.setItem(i, stack);
    }

    private static String getSlotKey(int slot) {
        return "i" + slot;
    }

    public static boolean hasItemInSlot(CompoundTag tag, int slot) {
        return tag.contains(ContainerUtil.getSlotKey(slot));
    }

    public static ItemStack getItemInSlot(CompoundTag tag, int i, HolderLookup.Provider provider) {
        return ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(ContainerUtil.getSlotKey(i)));
    }
}

