/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class CheckboxWidget
extends AbstractButton {
    private static final ResourceLocation CHECKBOX_SELECTED_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/checkbox_selected_highlighted");
    private static final ResourceLocation CHECKBOX_SELECTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/checkbox_selected");
    private static final ResourceLocation CHECKBOX_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/checkbox_highlighted");
    private static final ResourceLocation CHECKBOX_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/checkbox");
    private static final int CHECKBOX_TEXT_SPACING = 4;
    private boolean selected;
    private final TextMarquee marquee;
    private final Size size;
    @Nullable
    private OnPressed onPressed;
    @Nullable
    private Component helpTooltip;

    public CheckboxWidget(int x, int y, Component text, Font font, boolean selected, Size size) {
        this(x, y, size.widthHeight + 4 + font.width((FormattedText)text), text, font, selected, size);
    }

    public CheckboxWidget(int x, int y, int maxWidth, Component text, Font font, boolean selected, Size size) {
        super(x, y, CheckboxWidget.getWidth(maxWidth, text, font, size), size.widthHeight, text);
        this.marquee = new TextMarquee(text, maxWidth - 4 - size.widthHeight);
        this.selected = selected;
        this.size = size;
    }

    private static int getWidth(int maxWidth, Component text, Font font, Size size) {
        return Math.min(maxWidth, size.widthHeight + 4 + font.width((FormattedText)text));
    }

    public void setHelpTooltip(@Nullable Component helpTooltip) {
        this.helpTooltip = helpTooltip;
    }

    public void setOnPressed(@Nullable OnPressed onPressed) {
        this.onPressed = onPressed;
    }

    public void onPress() {
        boolean bl = this.selected = !this.selected;
        if (this.onPressed != null) {
            this.onPressed.onPressed(this, this.selected);
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
            } else {
                output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Screen screen;
        Minecraft minecraft = Minecraft.getInstance();
        if (this.isHovered && this.helpTooltip != null && (screen = minecraft.screen) instanceof AbstractBaseScreen) {
            AbstractBaseScreen screen2 = (AbstractBaseScreen)screen;
            screen2.setDeferredTooltip(List.of(HelpClientTooltipComponent.createAlwaysDisplayed(this.helpTooltip)));
        }
        RenderSystem.enableDepthTest();
        Font font = minecraft.font;
        graphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        ResourceLocation sprite = this.selected ? (this.isFocused() ? CHECKBOX_SELECTED_HIGHLIGHTED_SPRITE : CHECKBOX_SELECTED_SPRITE) : (this.isFocused() ? CHECKBOX_HIGHLIGHTED_SPRITE : CHECKBOX_SPRITE);
        graphics.blitSprite(sprite, this.getX(), this.getY(), this.size.widthHeight, this.size.widthHeight);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int textX = this.getX() + this.size.widthHeight + 4;
        int textY = this.getY() + (this.height >> 1) - 4;
        this.marquee.render(graphics, textX, textY, font, this.isHovered);
    }

    public static enum Size {
        REGULAR(17),
        SMALL(9);

        private final int widthHeight;

        private Size(int widthHeight) {
            this.widthHeight = widthHeight;
        }
    }

    @FunctionalInterface
    public static interface OnPressed {
        public void onPressed(CheckboxWidget var1, boolean var2);
    }
}

