/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.network.impl.node.task.DefaultSchedulingMode;
import com.refinedmods.refinedstorage.api.network.impl.node.task.RandomSchedulingMode;
import com.refinedmods.refinedstorage.api.network.impl.node.task.RoundRobinSchedulingMode;
import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum SchedulingModeType {
    DEFAULT(0, "default"),
    ROUND_ROBIN(1, "round_robin"),
    RANDOM(2, "random");

    private static final String TAG_ROUND_ROBIN_INDEX = "rri";
    private final int id;
    private final MutableComponent name;
    private final Component help;

    private SchedulingModeType(int id, String name) {
        this.id = id;
        this.name = IdentifierUtil.createTranslation("gui", "scheduling_mode." + name);
        this.help = IdentifierUtil.createTranslation("gui", "scheduling_mode." + name + ".help");
    }

    public static SchedulingModeType getById(int id) {
        for (SchedulingModeType mode : SchedulingModeType.values()) {
            if (mode.id != id) continue;
            return mode;
        }
        return DEFAULT;
    }

    public MutableComponent getName() {
        return this.name;
    }

    public Component getHelpText() {
        return this.help;
    }

    public int getId() {
        return this.id;
    }

    public SchedulingMode createSchedulingMode(@Nullable CompoundTag tag, RandomSchedulingMode.Randomizer randomizer, Runnable listener) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new DefaultSchedulingMode();
            case 2 -> new RandomSchedulingMode(randomizer);
            case 1 -> this.createRoundRobinSchedulingMode(tag, listener);
        };
    }

    private RoundRobinSchedulingMode createRoundRobinSchedulingMode(@Nullable CompoundTag tag, Runnable listener) {
        int index = tag != null ? tag.getInt(TAG_ROUND_ROBIN_INDEX) : 0;
        return new RoundRobinSchedulingMode(new RoundRobinSchedulingMode.State(listener, index));
    }

    public void writeToTag(CompoundTag tag, SchedulingMode schedulingMode) {
        if (schedulingMode instanceof RoundRobinSchedulingMode) {
            RoundRobinSchedulingMode roundRobin = (RoundRobinSchedulingMode)schedulingMode;
            tag.putInt(TAG_ROUND_ROBIN_INDEX, roundRobin.getIndex());
        }
    }
}

