/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.screen;

import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.GridViewType;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class ViewTypeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "grid.view_type");
    private static final List<MutableComponent> SUBTEXT_ALL = List.of(IdentifierUtil.createTranslation("gui", "grid.view_type.all").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_AUTOCRAFTABLE = List.of(IdentifierUtil.createTranslation("gui", "grid.view_type.autocraftable").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_NON_AUTOCRAFTABLE = List.of(IdentifierUtil.createTranslation("gui", "grid.view_type.non_autocraftable").withStyle(ChatFormatting.GRAY));
    private static final ResourceLocation ALL = IdentifierUtil.createIdentifier("widget/side_button/grid/view_type/all");
    private static final ResourceLocation CRAFTABLE = IdentifierUtil.createIdentifier("widget/side_button/grid/view_type/autocraftable");
    private static final ResourceLocation NON_CRAFTABLE = IdentifierUtil.createIdentifier("widget/side_button/grid/view_type/non_autocraftable");
    private final AbstractGridContainerMenu menu;

    ViewTypeSideButtonWidget(AbstractGridContainerMenu menu) {
        super(ViewTypeSideButtonWidget.createPressAction(menu));
        this.menu = menu;
    }

    private static Button.OnPress createPressAction(AbstractGridContainerMenu menu) {
        return btn -> menu.setViewType(ViewTypeSideButtonWidget.toggle(menu.getViewType()));
    }

    private static GridViewType toggle(GridViewType sortingType) {
        return switch (sortingType) {
            default -> throw new MatchException(null, null);
            case GridViewType.ALL -> GridViewType.AUTOCRAFTABLE;
            case GridViewType.AUTOCRAFTABLE -> GridViewType.NON_AUTOCRAFTABLE;
            case GridViewType.NON_AUTOCRAFTABLE -> GridViewType.ALL;
        };
    }

    @Override
    protected ResourceLocation getSprite() {
        return switch (this.menu.getViewType()) {
            default -> throw new MatchException(null, null);
            case GridViewType.ALL -> ALL;
            case GridViewType.AUTOCRAFTABLE -> CRAFTABLE;
            case GridViewType.NON_AUTOCRAFTABLE -> NON_CRAFTABLE;
        };
    }

    @Override
    protected MutableComponent getTitle() {
        return TITLE;
    }

    @Override
    protected List<MutableComponent> getSubText() {
        return switch (this.menu.getViewType()) {
            default -> throw new MatchException(null, null);
            case GridViewType.ALL -> SUBTEXT_ALL;
            case GridViewType.AUTOCRAFTABLE -> SUBTEXT_AUTOCRAFTABLE;
            case GridViewType.NON_AUTOCRAFTABLE -> SUBTEXT_NON_AUTOCRAFTABLE;
        };
    }
}

