/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.screen;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.content.KeyMappings;
import com.refinedmods.refinedstorage.common.grid.AbstractCraftingGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.CraftingGridMatrixCloseBehavior;
import com.refinedmods.refinedstorage.common.grid.screen.AbstractGridScreen;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.CustomButton;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CraftingGridScreen
extends AbstractGridScreen<AbstractCraftingGridContainerMenu> {
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/crafting_grid.png");
    private static final WidgetSprites CLEAR_BUTTON_TO_PLAYER_INVENTORY_SPRITES = new WidgetSprites(IdentifierUtil.createIdentifier("widget/move_down"), IdentifierUtil.createIdentifier("widget/move_down_disabled"), IdentifierUtil.createIdentifier("widget/move_down_focused"), IdentifierUtil.createIdentifier("widget/move_down_disabled"));
    private static final WidgetSprites CLEAR_BUTTON_TO_NETWORK_SPRITES = new WidgetSprites(IdentifierUtil.createIdentifier("widget/move_up"), IdentifierUtil.createIdentifier("widget/move_up_disabled"), IdentifierUtil.createIdentifier("widget/move_up_focused"), IdentifierUtil.createIdentifier("widget/move_up_disabled"));
    private static final ResourceLocation CRAFTING_MATRIX_FILTERING_SLOT_HIGHLIGHT = IdentifierUtil.createIdentifier("crafting_grid/crafting_matrix_filtering_slot_highlight");
    @Nullable
    private CustomButton clearToNetworkButton;
    private boolean filteringBasedOnCraftingMatrixItems;

    public CraftingGridScreen(AbstractCraftingGridContainerMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title, 156);
        this.inventoryLabelY = 134;
        this.imageWidth = 193;
        this.imageHeight = 229;
    }

    @Override
    protected void init() {
        super.init();
        int clearToNetworkButtonX = this.getClearButtonX(0);
        int clearToInventoryButtonX = this.getClearButtonX(1);
        int clearButtonY = this.topPos + this.imageHeight - this.bottomHeight + 4;
        this.clearToNetworkButton = this.createClearButton(clearToNetworkButtonX, clearButtonY, false);
        this.setClearToNetworkButtonActive(((AbstractCraftingGridContainerMenu)this.getMenu()).isActive());
        ((AbstractCraftingGridContainerMenu)this.getMenu()).setActivenessListener(this::setClearToNetworkButtonActive);
        this.addRenderableWidget((GuiEventListener)this.clearToNetworkButton);
        this.addRenderableWidget((GuiEventListener)this.createClearButton(clearToInventoryButtonX, clearButtonY, true));
    }

    private int getClearButtonX(int i) {
        return this.leftPos + 81 + 9 * i;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        if (this.filteringBasedOnCraftingMatrixItems) {
            this.renderCraftingMatrixFilteringHighlights(graphics);
        }
    }

    private void renderCraftingMatrixFilteringHighlights(GuiGraphics graphics) {
        for (Slot slot : ((AbstractCraftingGridContainerMenu)this.getMenu()).getCraftingMatrixSlots()) {
            if (!slot.hasItem()) continue;
            graphics.blitSprite(CRAFTING_MATRIX_FILTERING_SLOT_HIGHLIGHT, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 18, 18);
        }
    }

    @Override
    protected void containerTick() {
        boolean mayFilterOnCraftingMatrixItems;
        super.containerTick();
        boolean bl = mayFilterOnCraftingMatrixItems = this.hoveredSlot != null && this.hoveredSlot.container instanceof ResultContainer && CraftingGridScreen.hasShiftDown() && CraftingGridScreen.hasControlDown();
        if (mayFilterOnCraftingMatrixItems && !this.filteringBasedOnCraftingMatrixItems) {
            this.filteringBasedOnCraftingMatrixItems = true;
            ((AbstractCraftingGridContainerMenu)this.getMenu()).filterBasedOnCraftingMatrixItems();
            if (this.searchField != null) {
                this.searchField.setEditable(false);
            }
        } else if (!mayFilterOnCraftingMatrixItems && this.filteringBasedOnCraftingMatrixItems) {
            ((AbstractCraftingGridContainerMenu)this.getMenu()).stopFilteringBasedOnCraftingMatrixItems();
            this.filteringBasedOnCraftingMatrixItems = false;
            if (this.searchField != null) {
                this.searchField.setEditable(true);
            }
        }
    }

    private void setClearToNetworkButtonActive(boolean active) {
        if (this.clearToNetworkButton == null) {
            return;
        }
        this.clearToNetworkButton.active = active;
    }

    private CustomButton createClearButton(int x, int y, boolean toPlayerInventory) {
        MutableComponent text = IdentifierUtil.createTranslation("gui", "crafting_grid.move." + (toPlayerInventory ? "inventory" : "network"));
        KeyMapping keyMapping = this.getClearButtonKeyMapping(toPlayerInventory);
        if (keyMapping != null) {
            text.append("\n").append((Component)keyMapping.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.GRAY));
        }
        WidgetSprites widgetSprites = toPlayerInventory ? CLEAR_BUTTON_TO_PLAYER_INVENTORY_SPRITES : CLEAR_BUTTON_TO_NETWORK_SPRITES;
        CustomButton button = new CustomButton(x, y, 7, 7, widgetSprites, b -> ((AbstractCraftingGridContainerMenu)this.getMenu()).clear(toPlayerInventory), (Component)text);
        button.setTooltip(Tooltip.create((Component)text));
        return button;
    }

    @Nullable
    private KeyMapping getClearButtonKeyMapping(boolean toPlayerInventory) {
        return toPlayerInventory ? this.wrapUnbound(KeyMappings.INSTANCE.getClearCraftingGridMatrixToInventory()) : this.wrapUnbound(KeyMappings.INSTANCE.getClearCraftingGridMatrixToNetwork());
    }

    @Nullable
    private KeyMapping wrapUnbound(@Nullable KeyMapping keyMapping) {
        return keyMapping == null || keyMapping.isUnbound() ? null : keyMapping;
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (KeyMappings.INSTANCE.getClearCraftingGridMatrixToInventory() != null && Platform.INSTANCE.isKeyDown(KeyMappings.INSTANCE.getClearCraftingGridMatrixToInventory())) {
            ((AbstractCraftingGridContainerMenu)this.getMenu()).clear(true);
        } else if (KeyMappings.INSTANCE.getClearCraftingGridMatrixToNetwork() != null && Platform.INSTANCE.isKeyDown(KeyMappings.INSTANCE.getClearCraftingGridMatrixToNetwork())) {
            ((AbstractCraftingGridContainerMenu)this.getMenu()).clear(false);
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public void onClose() {
        CraftingGridMatrixCloseBehavior behavior = Platform.INSTANCE.getConfig().getCraftingGrid().getCraftingMatrixCloseBehavior();
        if (behavior == CraftingGridMatrixCloseBehavior.CLEAR_TO_NETWORK) {
            ((AbstractCraftingGridContainerMenu)this.getMenu()).clear(false);
        } else if (behavior == CraftingGridMatrixCloseBehavior.CLEAR_TO_INVENTORY) {
            ((AbstractCraftingGridContainerMenu)this.getMenu()).clear(true);
        }
        super.onClose();
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        boolean hoveredSlotValidForHelp;
        boolean bl = hoveredSlotValidForHelp = this.hoveredSlot != null && this.hoveredSlot.container instanceof ResultContainer && this.hoveredSlot.hasItem();
        if (((AbstractCraftingGridContainerMenu)this.getMenu()).getCarried().isEmpty() && hoveredSlotValidForHelp && !this.filteringBasedOnCraftingMatrixItems) {
            ItemStack stack = this.hoveredSlot.getItem();
            List lines = this.getTooltipFromContainerItem(stack);
            List<ClientTooltipComponent> processedLines = Platform.INSTANCE.processTooltipComponents(stack, graphics, x, stack.getTooltipImage(), lines);
            processedLines.add(HelpClientTooltipComponent.create((Component)IdentifierUtil.createTranslation("gui", "crafting_grid.press_shift_ctrl_to_only_show_items_used_in_crafting")));
            Platform.INSTANCE.renderTooltip(graphics, processedLines, x, y);
            return;
        }
        super.renderTooltip(graphics, x, y);
    }
}

