/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import java.util.Comparator;
import java.util.function.Function;
import javax.annotation.Nullable;

public enum GridSortingTypes {
    QUANTITY(trp -> view -> Comparator.comparingLong(value -> value.getAmount((ResourceRepository<GridResource>)view))),
    NAME(trp -> view -> Comparator.comparing(GridResource::getName)),
    ID(trp -> view -> (a, b) -> {
        if (a instanceof GridResource) {
            GridResource aa = a;
            if (b instanceof GridResource) {
                GridResource bb = b;
                return Integer.compare(aa.getRegistryId(), bb.getRegistryId());
            }
        }
        return 0;
    }),
    LAST_MODIFIED(trp -> view -> (a, b) -> {
        long lastModifiedA = GridSortingTypes.extractTime(trp.getTrackedResource((GridResource)a));
        long lastModifiedB = GridSortingTypes.extractTime(trp.getTrackedResource((GridResource)b));
        return Long.compare(lastModifiedA, lastModifiedB);
    });

    private final Function<TrackedResourceProvider, Function<ResourceRepository<GridResource>, Comparator<GridResource>>> comparator;

    private GridSortingTypes(Function<TrackedResourceProvider, Function<ResourceRepository<GridResource>, Comparator<GridResource>>> c) {
        this.comparator = c;
    }

    public Function<ResourceRepository<GridResource>, Comparator<GridResource>> apply(TrackedResourceProvider context) {
        return this.comparator.apply(context);
    }

    private static long extractTime(@Nullable TrackedResource trackedResource) {
        return trackedResource != null ? trackedResource.getTime() : 0L;
    }

    @FunctionalInterface
    public static interface TrackedResourceProvider {
        @Nullable
        public TrackedResource getTrackedResource(GridResource var1);
    }
}

