/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridNetworkNode;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.grid.AbstractGridBlockEntity;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.CraftingGrid;
import com.refinedmods.refinedstorage.common.grid.CraftingGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.DirectCommitExtractTransaction;
import com.refinedmods.refinedstorage.common.grid.ExtractTransaction;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.grid.SnapshotExtractTransaction;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.RecipeMatrix;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CraftingGridBlockEntity
extends AbstractGridBlockEntity
implements BlockEntityWithDrops,
NetworkNodeExtendedMenuProvider<GridData>,
CraftingGrid {
    private static final String TAG_MATRIX = "matrix";
    private final RecipeMatrix<CraftingRecipe, CraftingInput> craftingRecipe = RecipeMatrix.crafting(() -> ((CraftingGridBlockEntity)this).setChanged(), () -> ((CraftingGridBlockEntity)this).getLevel());

    public CraftingGridBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getCraftingGrid(), pos, state, Platform.INSTANCE.getConfig().getCraftingGrid().getEnergyUsage());
    }

    @Override
    public RecipeMatrixContainer getCraftingMatrix() {
        return this.craftingRecipe.getMatrix();
    }

    @Override
    public ResultContainer getCraftingResult() {
        return this.craftingRecipe.getResult();
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(Player player, CraftingInput input) {
        return this.craftingRecipe.getRemainingItems(this.level, player, input);
    }

    @Override
    public ExtractTransaction startExtractTransaction(Player player, boolean directCommit) {
        return this.getNetwork().map(network -> network.getComponent(StorageNetworkComponent.class)).map(storage -> directCommit ? new DirectCommitExtractTransaction((RootStorage)storage) : new SnapshotExtractTransaction(player, (RootStorage)storage, this.getCraftingMatrix())).orElse(ExtractTransaction.NOOP);
    }

    @Override
    public boolean clearMatrix(Player player, boolean toPlayerInventory) {
        return toPlayerInventory ? this.getCraftingMatrix().clearToPlayerInventory(player) : this.clearMatrixIntoStorage(player);
    }

    private boolean clearMatrixIntoStorage(Player player) {
        return this.getNetwork().map(network -> network.getComponent(StorageNetworkComponent.class)).map(storage -> this.getCraftingMatrix().clearIntoStorage((RootStorage)storage, player)).orElse(false);
    }

    @Override
    public void transferRecipe(Player player, List<List<ItemResource>> recipe) {
        this.getCraftingMatrix().transferRecipe(player, this.getNetwork().map(network -> network.getComponent(StorageNetworkComponent.class)).orElse(null), recipe);
    }

    @Override
    public void acceptQuickCraft(Player player, ItemStack craftedStack) {
        if (player.getInventory().add(craftedStack)) {
            return;
        }
        long inserted = this.getNetwork().map(network -> network.getComponent(StorageNetworkComponent.class)).map(rootStorage -> rootStorage.insert(ItemResource.ofItemStack(craftedStack), craftedStack.getCount(), Action.EXECUTE, new PlayerActor(player))).orElse(0L);
        if (inserted != (long)craftedStack.getCount()) {
            long remainder = (long)craftedStack.getCount() - inserted;
            ItemStack remainderStack = craftedStack.copyWithCount((int)remainder);
            player.drop(remainderStack, false);
        }
    }

    @Override
    public GridData getMenuData() {
        return GridData.of(this);
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, GridData> getMenuCodec() {
        return GridData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.CRAFTING_GRID);
    }

    @Nullable
    public AbstractGridContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new CraftingGridContainerMenu(syncId, inventory, this);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_MATRIX, (Tag)this.craftingRecipe.writeToTag(provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(TAG_MATRIX)) {
            this.craftingRecipe.readFromTag(tag.getCompound(TAG_MATRIX), provider);
        }
    }

    @Override
    public void setLevel(Level level) {
        super.setLevel(level);
        this.craftingRecipe.updateResult(level);
    }

    @Override
    public final NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < this.craftingRecipe.getMatrix().getContainerSize(); ++i) {
            drops.add((Object)this.craftingRecipe.getMatrix().getItem(i));
        }
        return drops;
    }

    private Optional<Network> getNetwork() {
        if (!((GridNetworkNode)this.mainNetworkNode).isActive()) {
            return Optional.empty();
        }
        return Optional.ofNullable(((GridNetworkNode)this.mainNetworkNode).getNetwork());
    }
}

