/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategy;
import com.refinedmods.refinedstorage.common.api.constructordestructor.ConstructorStrategyFactory;
import com.refinedmods.refinedstorage.common.constructordestructor.AutocraftOnMissingResourcesConstructorStrategy;
import com.refinedmods.refinedstorage.common.constructordestructor.CompositeConstructorStrategy;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorContainerMenu;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorData;
import com.refinedmods.refinedstorage.common.constructordestructor.ConstructorNetworkNode;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.SchedulingModeContainer;
import com.refinedmods.refinedstorage.common.support.SchedulingModeType;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractConstructorBlockEntity
extends AbstractCableLikeBlockEntity<ConstructorNetworkNode>
implements BlockEntityWithDrops,
NetworkNodeExtendedMenuProvider<ConstructorData> {
    private static final String TAG_DROP_ITEMS = "di";
    private static final String TAG_UPGRADES = "upgr";
    private final UpgradeContainer upgradeContainer = new UpgradeContainer(UpgradeDestinations.CONSTRUCTOR, (c, upgradeEnergyUsage) -> {
        long baseEnergyUsage = Platform.INSTANCE.getConfig().getConstructor().getEnergyUsage();
        ((ConstructorNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
        this.setChanged();
        Level patt0$temp = this.level;
        if (patt0$temp instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)patt0$temp;
            this.initialize(serverLevel);
        }
    }, 20);
    private final FilterWithFuzzyMode filter;
    private final SchedulingModeContainer schedulingModeContainer;
    private boolean dropItems;

    protected AbstractConstructorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getConstructor(), pos, state, new ConstructorNetworkNode(Platform.INSTANCE.getConfig().getConstructor().getEnergyUsage()));
        this.ticker = this.upgradeContainer.getTicker();
        this.schedulingModeContainer = new SchedulingModeContainer(schedulingMode -> {
            ((ConstructorNetworkNode)this.mainNetworkNode).setSchedulingMode((SchedulingMode)schedulingMode);
            this.setChanged();
        });
        this.filter = FilterWithFuzzyMode.createAndListenForFilters(ResourceContainerImpl.createForFilter(), () -> ((AbstractConstructorBlockEntity)this).setChanged(), this::setFilters);
    }

    void setFilters(List<ResourceKey> filters) {
        ((ConstructorNetworkNode)this.mainNetworkNode).setFilters(filters);
    }

    @Override
    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    @Override
    protected void initialize(ServerLevel level, Direction direction) {
        super.initialize(level, direction);
        ((ConstructorNetworkNode)this.mainNetworkNode).setPlayerProvider(() -> this.getFakePlayer(level));
        ((ConstructorNetworkNode)this.mainNetworkNode).setStrategy(this.createStrategy(level, direction));
    }

    private ConstructorStrategy createStrategy(ServerLevel serverLevel, Direction direction) {
        Direction incomingDirection = direction.getOpposite();
        BlockPos sourcePosition = this.worldPosition.relative(direction);
        Collection<ConstructorStrategyFactory> factories = RefinedStorageApi.INSTANCE.getConstructorStrategyFactories();
        List<ConstructorStrategy> strategies = factories.stream().flatMap(factory -> factory.create(serverLevel, sourcePosition, incomingDirection, this.upgradeContainer, this.dropItems).stream()).toList();
        CompositeConstructorStrategy strategy = new CompositeConstructorStrategy(strategies);
        if (this.upgradeContainer.has(Items.INSTANCE.getAutocraftingUpgrade())) {
            return new AutocraftOnMissingResourcesConstructorStrategy(strategy);
        }
        return strategy;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, provider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read(tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, provider);
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putBoolean(TAG_DROP_ITEMS, this.dropItems);
        this.schedulingModeContainer.writeToTag(tag);
        this.filter.save(tag, provider);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains(TAG_DROP_ITEMS)) {
            this.dropItems = tag.getBoolean(TAG_DROP_ITEMS);
        }
        this.schedulingModeContainer.loadFromTag(tag);
        this.filter.load(tag, provider);
    }

    void setSchedulingModeType(SchedulingModeType type) {
        this.schedulingModeContainer.setType(type);
    }

    SchedulingModeType getSchedulingModeType() {
        return this.schedulingModeContainer.getType();
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initialize(serverLevel);
        }
    }

    @Override
    public final NonNullList<ItemStack> getDrops() {
        return this.upgradeContainer.getDrops();
    }

    boolean isDropItems() {
        return this.dropItems;
    }

    void setDropItems(boolean dropItems) {
        this.dropItems = dropItems;
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initialize(serverLevel);
        }
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.CONSTRUCTOR);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new ConstructorContainerMenu(syncId, player, this, this.filter.getFilterContainer(), this.upgradeContainer, this.getExportingIndicators());
    }

    private ExportingIndicators getExportingIndicators() {
        return new ExportingIndicators(this.filter.getFilterContainer(), i -> this.toExportingIndicator(((ConstructorNetworkNode)this.mainNetworkNode).getLastResult(i)), false);
    }

    private ExportingIndicator toExportingIndicator(@Nullable ConstructorStrategy.Result result) {
        ConstructorStrategy.Result result2 = result;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RESOURCE_MISSING", "AUTOCRAFTING_STARTED", "AUTOCRAFTING_MISSING_RESOURCES"}, (ConstructorStrategy.Result)result2, n)) {
            case 0 -> ExportingIndicator.RESOURCE_MISSING;
            case 1 -> ExportingIndicator.AUTOCRAFTING_WAS_STARTED;
            case 2 -> ExportingIndicator.AUTOCRAFTING_MISSING_RESOURCES;
            default -> ExportingIndicator.NONE;
        };
    }

    @Override
    public ConstructorData getMenuData() {
        return new ConstructorData(ResourceContainerData.of(this.filter.getFilterContainer()), this.getExportingIndicators().getAll());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, ConstructorData> getMenuCodec() {
        return ConstructorData.STREAM_CODEC;
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

