/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.preview;

import com.google.common.util.concurrent.RateLimiter;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewItem;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewType;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewListener;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewStyle;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingRequest;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingRequestButton;
import com.refinedmods.refinedstorage.common.autocrafting.preview.FullscreenTreePreviewScreen;
import com.refinedmods.refinedstorage.common.autocrafting.preview.TreePreviewWidget;
import com.refinedmods.refinedstorage.common.support.amount.AbstractAmountScreen;
import com.refinedmods.refinedstorage.common.support.amount.ActionIcon;
import com.refinedmods.refinedstorage.common.support.amount.AmountScreenConfiguration;
import com.refinedmods.refinedstorage.common.support.amount.DoubleAmountOperations;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.refinedmods.refinedstorage.common.support.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.common.support.widget.ImageButton;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.joml.Vector3f;

public class AutocraftingPreviewScreen
extends AbstractAmountScreen<AutocraftingPreviewContainerMenu, Double>
implements AutocraftingPreviewListener {
    static final int REQUEST_BUTTON_HEIGHT = 24;
    static final int REQUEST_BUTTON_WIDTH = 64;
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/autocrafting_preview.png");
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation("gui", "autocrafting_preview.title");
    private static final MutableComponent START = IdentifierUtil.createTranslation("gui", "autocrafting_preview.start");
    private static final MutableComponent PENDING = IdentifierUtil.createTranslation("gui", "autocrafting_preview.pending");
    private static final MutableComponent CANCELLING = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cancelling");
    private static final MutableComponent CANCELLING_FORCE_CLOSE = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cancelling.force_close");
    private static final MutableComponent MAX = IdentifierUtil.createTranslation("gui", "autocrafting_preview.max");
    private static final MutableComponent MAX_HELP = IdentifierUtil.createTranslation("gui", "autocrafting_preview.max.help");
    private static final MutableComponent NOTIFY = IdentifierUtil.createTranslation("gui", "autocrafting_preview.notify");
    private static final MutableComponent NOTIFY_HELP = IdentifierUtil.createTranslation("gui", "autocrafting_preview.notify.help");
    private static final MutableComponent MISSING_RESOURCES = IdentifierUtil.createTranslation("gui", "autocrafting_preview.start.missing_resources");
    private static final MutableComponent CYCLE_DETECTED = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cycle_detected").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private static final MutableComponent CYCLE_OUTPUTS = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cycle_detected.outputs");
    private static final MutableComponent BREAK_THE_CYCLE_AND_TRY_AGAIN = IdentifierUtil.createTranslation("gui", "autocrafting_preview.cycle_detected.break_the_cycle_and_try_again");
    private static final MutableComponent REQUEST_TOO_LARGE_TO_HANDLE = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_too_large_to_handle").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private static final MutableComponent TRY_SMALLER_AMOUNT = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_too_large_to_handle.try_smaller_amount");
    private static final MutableComponent REQUEST_CANCELLED = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_cancelled").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
    private static final MutableComponent TOO_MANY_SUBCOMPONENTS = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_cancelled.too_many_subcomponents");
    private static final MutableComponent CRAFT_SUBCOMPONENTS_AND_TRY_AGAIN = IdentifierUtil.createTranslation("gui", "autocrafting_preview.request_cancelled.craft_subcomponents_and_try_again");
    private static final MutableComponent NOT_AVAILABLE = IdentifierUtil.createTranslation("gui", "autocrafting_preview.not_available");
    private static final MutableComponent ZOOM = IdentifierUtil.createTranslation("gui", "autocrafting_preview.zoom");
    private static final ResourceLocation ROW = IdentifierUtil.createIdentifier("autocrafting_preview/row");
    private static final ResourceLocation CRAFTING_REQUESTS = IdentifierUtil.createIdentifier("autocrafting_preview/requests");
    private static final ResourceLocation LIST_PREVIEW = IdentifierUtil.createIdentifier("autocrafting_preview/list_preview");
    private static final ResourceLocation TREE_PREVIEW = IdentifierUtil.createIdentifier("autocrafting_preview/tree_preview");
    private static final ResourceLocation TREE_PREVIEW_VIGNETTE = IdentifierUtil.createIdentifier("autocrafting_preview/tree_preview_vignette");
    private static final ResourceLocation LIST_ICON = IdentifierUtil.createIdentifier("widget/autocrafting_list_preview");
    private static final ResourceLocation TREE_ICON = IdentifierUtil.createIdentifier("widget/autocrafting_tree_preview");
    private static final ResourceLocation ZOOM_ICON = IdentifierUtil.createIdentifier("widget/autocrafting_zoom_tree_preview");
    private static final int ROWS_VISIBLE = 4;
    private static final int COLUMNS = 3;
    private static final int PREVIEW_AREA_WIDTH = 241;
    private static final int PREVIEW_AREA_HEIGHT = 121;
    private static final int PREVIEW_AREA_CONTENTS_LIST_WIDTH = 221;
    private static final int PREVIEW_AREA_CONTENTS_TREE_WIDTH = 239;
    private static final int PREVIEW_AREA_CONTENTS_HEIGHT = 119;
    private static final int ROW_HEIGHT = 30;
    private static final int ROW_WIDTH = 221;
    private static final int CELL_WIDTH = 73;
    private static final int CELL_HEIGHT = 29;
    private static final int REQUESTS_WIDTH = 91;
    private static final int REQUESTS_HEIGHT = 111;
    private static final int REQUESTS_INNER_WIDTH = 64;
    private static final int REQUESTS_INNER_HEIGHT = 96;
    private static final int REQUESTS_VISIBLE = 4;
    private static final int ITEM_COLOR = -2368549;
    private static final int MISSING_COLOR = -860450;
    @Nullable
    private ScrollbarWidget scrollbar;
    @Nullable
    private ScrollbarWidget requestButtonsScrollbar;
    @Nullable
    private Button maxButton;
    @Nullable
    private CheckboxWidget notifyCheckbox;
    @Nullable
    private Button zoomButton;
    @Nullable
    private TreePreviewWidget tree;
    private final List<AutocraftingRequestButton> requestButtons = new ArrayList<AutocraftingRequestButton>();
    private final boolean requestsButtonsVisible;
    private final RateLimiter requestRateLimiter = RateLimiter.create((double)1.0);
    private final RateLimiter maxAmountRequestRateLimiter = RateLimiter.create((double)0.2);
    @Nullable
    private Double changedAmount;
    private boolean mayEnableMaxAmountRequestButtonAgain;
    private boolean requestedCancellation;

    public AutocraftingPreviewScreen(Screen parent, Inventory playerInventory, List<AutocraftingRequest> requests) {
        this(new AutocraftingPreviewContainerMenu(requests), parent, playerInventory);
    }

    public AutocraftingPreviewScreen(AutocraftingPreviewContainerMenu menu, Inventory playerInventory) {
        this(menu, null, playerInventory);
    }

    public AutocraftingPreviewScreen(AutocraftingPreviewContainerMenu menu, @Nullable Screen parent, Inventory playerInventory) {
        super(menu, parent, playerInventory, (Component)TITLE, AmountScreenConfiguration.AmountScreenConfigurationBuilder.create().withInitialAmount(1.0).withIncrementsTop(1, 10, 64).withIncrementsTopStartPosition(new Vector3f(80.0f, 20.0f, 0.0f)).withIncrementsBottom(-1, -10, -64).withIncrementsBottomStartPosition(new Vector3f(80.0f, 71.0f, 0.0f)).withAmountFieldPosition(new Vector3f(77.0f, 51.0f, 0.0f)).withActionButtonsStartPosition(new Vector3f(7.0f, 222.0f, 0.0f)).withHorizontalActionButtons(true).withMinAmount(menu::getMinAmount).withResetAmount(1.0).withConfirmButtonText((Component)START).build(), DoubleAmountOperations.INSTANCE);
        this.imageWidth = 254;
        this.imageHeight = 249;
        this.requestsButtonsVisible = ((AutocraftingPreviewContainerMenu)this.getMenu()).getRequests().size() > 1;
        ((AutocraftingPreviewContainerMenu)this.getMenu()).setListener(this);
    }

    @Override
    protected void init() {
        boolean wasAlreadyInitialized = this.amountField != null;
        super.init();
        this.scrollbar = new ScrollbarWidget(this.leftPos + 235, this.topPos + 98, ScrollbarWidget.Type.NORMAL, 119);
        this.scrollbar.visible = false;
        this.scrollbar.setEnabled(false);
        if (this.requestsButtonsVisible) {
            this.initRequestButtons();
        }
        if (this.confirmButton != null) {
            this.disableStartButton();
        }
        if (!wasAlreadyInitialized) {
            ((AutocraftingPreviewContainerMenu)this.getMenu()).loadCurrentRequest();
        }
        boolean wasActive = this.maxButton == null || this.maxButton.active;
        this.maxButton = Button.builder((Component)MAX, this::requestMaxAmount).size(22, 15).pos(this.leftPos + 185 - 1, this.topPos + 49 - 1).build();
        this.maxButton.active = wasActive;
        this.addRenderableWidget((GuiEventListener)this.maxButton);
        this.tree = new TreePreviewWidget((Screen)this, this.leftPos + 8, this.topPos + 98, 239, 119);
        this.zoomButton = new ImageButton(this.leftPos + this.imageWidth - 6 - 16, this.topPos + 97 - 16, ZOOM_ICON, btn -> this.zoom());
        this.zoomButton.setTooltip(Tooltip.create((Component)ZOOM));
        this.zoomButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.zoomButton);
        AutocraftingPreviewStyle currentStyle = ((AutocraftingPreviewContainerMenu)this.menu).getStyle();
        ImageButton styleButton = new ImageButton(this.leftPos + this.imageWidth - 6 - 16 - 16, this.topPos + 97 - 16, currentStyle == AutocraftingPreviewStyle.LIST ? TREE_ICON : LIST_ICON, this::toggleStyle);
        this.addRenderableWidget((GuiEventListener)styleButton);
        this.updateStyle(styleButton, currentStyle);
        boolean selected = this.notifyCheckbox == null ? ((AutocraftingPreviewContainerMenu)this.menu).isNotify() : this.notifyCheckbox.isSelected();
        this.notifyCheckbox = new CheckboxWidget(this.leftPos + this.imageWidth - this.font.width((FormattedText)NOTIFY) - 4 - 9 - 6, this.topPos + 222 + 6, (Component)NOTIFY, Minecraft.getInstance().font, selected, CheckboxWidget.Size.SMALL);
        this.notifyCheckbox.setHelpTooltip((Component)NOTIFY_HELP);
        this.notifyCheckbox.setOnPressed((checkbox, notify) -> ((AutocraftingPreviewContainerMenu)this.menu).setNotify(notify));
        this.addRenderableWidget((GuiEventListener)this.notifyCheckbox);
        this.getExclusionZones().add(new Rect2i(this.leftPos - 91 + 4, this.topPos, 91, 111));
    }

    private void zoom() {
        TreePreview treePreview = ((AutocraftingPreviewContainerMenu)this.getMenu()).getCurrentRequest().getTreePreview();
        if (treePreview == null || treePreview.rootNode() == null) {
            return;
        }
        Minecraft.getInstance().setScreen((Screen)new FullscreenTreePreviewScreen((Screen)this, treePreview));
    }

    private void toggleStyle(ImageButton btn) {
        this.getAndValidateAmount().ifPresent(amount -> {
            AutocraftingPreviewStyle newStyle = ((AutocraftingPreviewContainerMenu)this.getMenu()).toggleStyle((double)amount);
            this.updateStyle(btn, newStyle);
        });
    }

    private void updateStyle(ImageButton btn, AutocraftingPreviewStyle newStyle) {
        btn.setTooltip(Tooltip.create((Component)(newStyle == AutocraftingPreviewStyle.TREE ? AutocraftingPreviewStyle.LIST.getName() : AutocraftingPreviewStyle.TREE.getName())));
        btn.setSprite(newStyle == AutocraftingPreviewStyle.TREE ? LIST_ICON : TREE_ICON);
        if (this.scrollbar == null || this.zoomButton == null) {
            return;
        }
        this.scrollbar.visible = newStyle == AutocraftingPreviewStyle.LIST;
        this.zoomButton.active = false;
    }

    @Override
    @Nullable
    protected ActionIcon getConfirmButtonIcon() {
        return null;
    }

    private void requestMaxAmount(Button button) {
        button.active = false;
        ((AutocraftingPreviewContainerMenu)this.getMenu()).requestMaxAmount();
    }

    private void initRequestButtons() {
        this.requestButtons.clear();
        this.requestButtonsScrollbar = new ScrollbarWidget(this.leftPos - 17 + 4, this.getRequestButtonsInnerY(), ScrollbarWidget.Type.NORMAL, 96);
        this.requestButtonsScrollbar.setListener(value -> {
            int scrollOffset = this.requestButtonsScrollbar.isSmoothScrolling() ? (int)this.requestButtonsScrollbar.getOffset() : (int)this.requestButtonsScrollbar.getOffset() * 24;
            for (int i = 0; i < this.requestButtons.size(); ++i) {
                AutocraftingRequestButton requestButton = this.requestButtons.get(i);
                int y = this.getCraftingRequestButtonY(i) - scrollOffset;
                requestButton.setY(y);
                requestButton.visible = this.isCraftingRequestButtonVisible(y);
            }
        });
        this.updateRequestsScrollbar();
        for (int i = 0; i < ((AutocraftingPreviewContainerMenu)this.getMenu()).getRequests().size(); ++i) {
            AutocraftingRequest request = ((AutocraftingPreviewContainerMenu)this.getMenu()).getRequests().get(i);
            int buttonY = this.getCraftingRequestButtonY(i);
            AutocraftingRequestButton button = new AutocraftingRequestButton(this.getRequestButtonsInnerX(), buttonY, request, this::changeCurrentRequest);
            button.visible = this.isCraftingRequestButtonVisible(buttonY);
            this.requestButtons.add((AutocraftingRequestButton)this.addWidget((GuiEventListener)button));
        }
    }

    private boolean isCraftingRequestButtonVisible(int y) {
        int innerY = this.getRequestButtonsInnerY();
        return y >= innerY - 24 && y <= innerY + 96;
    }

    private int getCraftingRequestButtonY(int i) {
        return this.getRequestButtonsInnerY() + i * 24;
    }

    private void changeCurrentRequest(AutocraftingRequest request) {
        ((AutocraftingPreviewContainerMenu)this.getMenu()).setCurrentRequest(request);
    }

    private void setRequest(AutocraftingRequest request) {
        for (AutocraftingRequestButton requestButton : this.requestButtons) {
            requestButton.active = requestButton.getRequest() != request;
        }
        this.updateAmount(request.getAmount());
        this.setPreview(request.getPreview(), request.getTreePreview());
    }

    private void setPreview(@Nullable Preview preview, @Nullable TreePreview treePreview) {
        if (this.scrollbar == null || this.tree == null || this.zoomButton == null) {
            return;
        }
        this.tree.update(treePreview);
        this.zoomButton.active = this.tree.hasContents();
        this.updateConfirmButton(preview, treePreview);
        if (preview == null && treePreview == null) {
            this.scrollbar.setEnabled(false);
            this.scrollbar.setMaxOffset(0.0);
            this.disableStartButton();
        } else if (preview != null) {
            int items = preview.items().size();
            int rows = Math.ceilDiv(items, 3) - 4;
            this.scrollbar.setMaxOffset(this.scrollbar.isSmoothScrolling() ? (double)(rows * 30) : (double)rows);
            this.scrollbar.setEnabled(rows > 0);
        }
    }

    private void updateConfirmButton(@Nullable Preview preview, @Nullable TreePreview treePreview) {
        if (this.confirmButton == null) {
            return;
        }
        this.confirmButton.setMessage((Component)START);
        boolean success = preview != null && preview.type() == PreviewType.SUCCESS || treePreview != null && treePreview.type() == PreviewType.SUCCESS;
        boolean missingResources = preview != null && preview.type() == PreviewType.MISSING_RESOURCES || treePreview != null && treePreview.type() == PreviewType.MISSING_RESOURCES;
        this.confirmButton.active = success;
        this.confirmButton.setIcon(success ? ActionIcon.START : ActionIcon.ERROR);
        this.confirmButton.setTooltip(missingResources ? Tooltip.create((Component)MISSING_RESOURCES) : null);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollbar != null) {
            this.scrollbar.render(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.requestButtonsScrollbar != null) {
            this.requestButtonsScrollbar.render(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.requestsButtonsVisible) {
            int requestsInnerX = this.getRequestButtonsInnerX();
            int requestsInnerY = this.getRequestButtonsInnerY();
            graphics.enableScissor(requestsInnerX, requestsInnerY, requestsInnerX + 64, requestsInnerY + 96);
            for (AutocraftingRequestButton requestButton : this.requestButtons) {
                requestButton.render(graphics, mouseX, mouseY, partialTicks);
            }
            graphics.disableScissor();
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        if (this.requestsButtonsVisible) {
            graphics.blitSprite(CRAFTING_REQUESTS, this.leftPos - 91 + 4, this.topPos, 91, 111);
        }
        int contentsX = this.leftPos + 8;
        int contentsY = this.topPos + 98;
        AutocraftingPreviewStyle style = ((AutocraftingPreviewContainerMenu)this.getMenu()).getStyle();
        this.renderContentsBackground(graphics, style, contentsX, contentsY);
        int contentsWidth = style == AutocraftingPreviewStyle.LIST ? 221 : 239;
        graphics.enableScissor(contentsX, contentsY, contentsX + contentsWidth, contentsY + 119);
        this.renderContents(graphics, mouseX, mouseY, style, contentsX, contentsY);
        graphics.disableScissor();
    }

    private void renderContentsBackground(GuiGraphics graphics, AutocraftingPreviewStyle style, int contentsX, int contentsY) {
        if (style == AutocraftingPreviewStyle.LIST) {
            graphics.blitSprite(LIST_PREVIEW, contentsX - 1, contentsY - 1, 241, 121);
        } else if (style == AutocraftingPreviewStyle.TREE) {
            graphics.blitSprite(TREE_PREVIEW, contentsX - 1, contentsY - 1, 241, 121);
        }
    }

    private void renderContents(GuiGraphics graphics, int mouseX, int mouseY, AutocraftingPreviewStyle style, int x, int y) {
        TreePreview treePreview;
        Preview preview = ((AutocraftingPreviewContainerMenu)this.getMenu()).getCurrentRequest().getPreview();
        PreviewType type = this.getType(preview, treePreview = ((AutocraftingPreviewContainerMenu)this.getMenu()).getCurrentRequest().getTreePreview());
        if (type != null && type != PreviewType.SUCCESS && type != PreviewType.MISSING_RESOURCES) {
            this.renderError(graphics, type, y, x, this.getOutputsOfPatternWithCycle(preview, treePreview));
        } else if (style == AutocraftingPreviewStyle.LIST) {
            this.renderListPreview(graphics, mouseX, mouseY, preview, x, y);
        } else if (style == AutocraftingPreviewStyle.TREE) {
            this.renderTreePreview(graphics, mouseX, mouseY, x, y);
        }
    }

    @Nullable
    private PreviewType getType(@Nullable Preview preview, @Nullable TreePreview treePreview) {
        if (preview != null) {
            return preview.type();
        }
        if (treePreview != null) {
            return treePreview.type();
        }
        return null;
    }

    private List<ResourceAmount> getOutputsOfPatternWithCycle(@Nullable Preview preview, @Nullable TreePreview treePreview) {
        if (preview != null) {
            return preview.outputsOfPatternWithCycle();
        }
        if (treePreview != null) {
            return treePreview.outputsOfPatternWithCycle();
        }
        return Collections.emptyList();
    }

    private void renderError(GuiGraphics graphics, PreviewType type, int y, int x, List<ResourceAmount> outputsOfPatternWithCycle) {
        if (type == PreviewType.CYCLE_DETECTED) {
            this.renderCycleDetected(graphics, y, x, outputsOfPatternWithCycle);
        } else if (type == PreviewType.OVERFLOW) {
            this.renderRequestTooLargeToHandle(graphics, x, y);
        } else if (type == PreviewType.CANCELLED) {
            this.renderCancelled(graphics, x, y);
        } else if (type == PreviewType.NOT_AVAILABLE) {
            this.renderNotAvailable(graphics, x, y);
        }
    }

    private void renderCycleDetected(GuiGraphics graphics, int y, int x, List<ResourceAmount> outputsOfPatternWithCycle) {
        int yy = y + 4;
        SmallText.render(graphics, this.font, CYCLE_DETECTED.getVisualOrderText(), x + 4, yy, 0xFF5555, false, 0.5f);
        SmallText.render(graphics, this.font, CYCLE_OUTPUTS.getVisualOrderText(), x + 4, yy += 10, 0x404040, false, 0.5f);
        yy += 10;
        for (ResourceAmount output : outputsOfPatternWithCycle) {
            ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(output.resource().getClass());
            rendering.render(output.resource(), graphics, x + 4, yy);
            SmallText.render(graphics, this.font, Component.literal((String)(output.amount() + "x ")).append(rendering.getDisplayName(output.resource())).getVisualOrderText(), x + 4 + 16 + 3, yy + 5, 0x404040, false, 0.5f);
            yy += 18;
        }
        SmallText.render(graphics, this.font, BREAK_THE_CYCLE_AND_TRY_AGAIN.getVisualOrderText(), x + 4, yy += 2, 0x404040, false, 0.5f);
    }

    private void renderRequestTooLargeToHandle(GuiGraphics graphics, int x, int y) {
        SmallText.render(graphics, this.font, REQUEST_TOO_LARGE_TO_HANDLE.getVisualOrderText(), x + 4, y + 4, 0xFF5555, false, 0.5f);
        SmallText.render(graphics, this.font, TRY_SMALLER_AMOUNT.getVisualOrderText(), x + 4, y + 4 + 10, 0x404040, false, 0.5f);
    }

    private void renderCancelled(GuiGraphics graphics, int x, int y) {
        SmallText.render(graphics, this.font, REQUEST_CANCELLED.getVisualOrderText(), x + 4, y + 4, 0xFF5555, false, 0.5f);
        SmallText.render(graphics, this.font, TOO_MANY_SUBCOMPONENTS.getVisualOrderText(), x + 4, y + 4 + 10, 0x404040, false, 0.5f);
        SmallText.render(graphics, this.font, CRAFT_SUBCOMPONENTS_AND_TRY_AGAIN.getVisualOrderText(), x + 4, y + 4 + 10 + 10, 0x404040, false, 0.5f);
    }

    private void renderNotAvailable(GuiGraphics graphics, int x, int y) {
        SmallText.render(graphics, this.font, NOT_AVAILABLE.getVisualOrderText(), x + 4, y + 4, 0xFF5555, false, 0.5f);
    }

    private void renderListPreview(GuiGraphics graphics, int mouseX, int mouseY, @Nullable Preview preview, int x, int y) {
        if (preview == null) {
            return;
        }
        List<PreviewItem> items = preview.items();
        int rows = Math.ceilDiv(items.size(), 3);
        for (int i = 0; i < rows; ++i) {
            int scrollOffset = this.getScrollOffset();
            int yy = y + i * 30 - scrollOffset;
            this.renderRow(graphics, x, yy, i, items, mouseX, mouseY);
        }
    }

    private int getScrollOffset() {
        if (this.scrollbar == null) {
            return 0;
        }
        return this.scrollbar.isSmoothScrolling() ? (int)this.scrollbar.getOffset() : (int)this.scrollbar.getOffset() * 30;
    }

    private void renderRow(GuiGraphics graphics, int x, int y, int i, List<PreviewItem> items, double mouseX, double mouseY) {
        if (y <= this.topPos + 98 - 30 || y > this.topPos + 98 + 119) {
            return;
        }
        graphics.blitSprite(ROW, x, y, 221, 30);
        for (int column = i * 3; column < Math.min(i * 3 + 3, items.size()); ++column) {
            PreviewItem item = items.get(column);
            int xx = x + column % 3 * 74;
            this.renderCell(graphics, xx, y, item, mouseX, mouseY);
        }
    }

    private void renderCell(GuiGraphics graphics, int x, int y, PreviewItem item, double mouseX, double mouseY) {
        this.renderCellBackground(graphics, x, y, item, mouseX, mouseY);
        int xx = x + 2;
        int yy = y + 7;
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(item.resource().getClass());
        rendering.render(item.resource(), graphics, xx, yy);
        if (this.isHovering(xx - this.leftPos, yy - this.topPos, 16, 16, mouseX, mouseY) && this.isHoveringOverPreviewArea(mouseX, mouseY)) {
            this.setTooltipForNextRenderPass(rendering.getTooltip(item.resource()).stream().map(Component::getVisualOrderText).toList());
        }
        if (!SmallText.isSmall()) {
            yy -= 2;
        }
        xx += 19;
        if (item.missing() > 0L) {
            this.renderCellText(graphics, "missing", rendering, xx, yy, item.missing());
            yy += 7;
        }
        if (item.available() > 0L) {
            this.renderCellText(graphics, "available", rendering, xx, yy, item.available());
            yy += 7;
        }
        if (item.toCraft() > 0L) {
            this.renderCellText(graphics, "to_craft", rendering, xx, yy, item.toCraft());
        }
    }

    private void renderCellBackground(GuiGraphics graphics, int x, int y, PreviewItem item, double mouseX, double mouseY) {
        boolean hovering = this.isHovering(x + 1 - this.leftPos, y + 1 - this.topPos, 72, 28, mouseX, mouseY);
        if (item.missing() > 0L || hovering) {
            int backgroundColor = item.missing() > 0L ? -860450 : -2368549;
            graphics.fill(x, y, x + 73, y + 29, hovering ? MathUtil.darkenARGB(backgroundColor, 0.1) : backgroundColor);
        }
    }

    private void renderCellText(GuiGraphics graphics, String type, ResourceRendering rendering, int x, int y, long amount) {
        SmallText.render(graphics, this.font, IdentifierUtil.createTranslation("gui", "autocrafting_preview." + type, rendering.formatAmount(amount, true)).getVisualOrderText(), x, y, 0x404040, false, 0.5f);
    }

    private void renderTreePreview(GuiGraphics graphics, int mouseX, int mouseY, int x, int y) {
        if (this.tree == null) {
            return;
        }
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 0.0f);
        this.tree.renderWidget(graphics, mouseX, mouseY, 0.0f);
        graphics.pose().popPose();
        this.renderTreePreviewVignette(graphics, x, y);
    }

    private void renderTreePreviewVignette(GuiGraphics graphics, int contentsX, int contentsY) {
        RenderSystem.enableBlend();
        graphics.blitSprite(TREE_PREVIEW_VIGNETTE, contentsX, contentsY, 239, 119);
        RenderSystem.disableBlend();
    }

    @Override
    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        super.renderTooltip(graphics, x, y);
        if (this.maxButton != null && this.maxButton.isHovered()) {
            Platform.INSTANCE.renderTooltip(graphics, List.of(HelpClientTooltipComponent.createAlwaysDisplayed((Component)MAX_HELP)), x, y);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        if (this.scrollbar != null && this.scrollbar.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        if (this.requestButtonsScrollbar != null && this.requestButtonsScrollbar.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    public void mouseMoved(double mx, double my) {
        if (this.scrollbar != null) {
            this.scrollbar.mouseMoved(mx, my);
        }
        if (this.requestButtonsScrollbar != null) {
            this.requestButtonsScrollbar.mouseMoved(mx, my);
        }
        super.mouseMoved(mx, my);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        if (this.scrollbar != null && this.scrollbar.mouseReleased(mx, my, button)) {
            return true;
        }
        if (this.requestButtonsScrollbar != null && this.requestButtonsScrollbar.mouseReleased(mx, my, button)) {
            return true;
        }
        return super.mouseReleased(mx, my, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.tree != null && this.tree.visible && this.isHoveringOverPreviewArea(mouseX, mouseY) && this.tree.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean mouseScrolled(double x, double y, double z, double delta) {
        boolean didPreviewItemsScrollbar = this.didScrollPreviewItemsScrollbar(x, y, z, delta);
        boolean didTreePreview = this.didScrollTreePreview(x, y, z, delta);
        if (didPreviewItemsScrollbar || didTreePreview) {
            return true;
        }
        boolean didRequestButtonsScrollbar = this.requestButtonsScrollbar != null && this.isHoveringOverRequestButtons(x, y) && this.requestButtonsScrollbar.mouseScrolled(x, y, z, delta);
        return didRequestButtonsScrollbar || super.mouseScrolled(x, y, z, delta);
    }

    private boolean didScrollTreePreview(double x, double y, double z, double delta) {
        return this.tree != null && this.tree.visible && this.isHoveringOverPreviewArea(x, y) && this.tree.mouseScrolled(x, y, z, delta);
    }

    private boolean didScrollPreviewItemsScrollbar(double x, double y, double z, double delta) {
        return this.scrollbar != null && this.scrollbar.visible && this.isHoveringOverPreviewArea(x, y) && this.scrollbar.mouseScrolled(x, y, z, delta);
    }

    private boolean isHoveringOverPreviewArea(double x, double y) {
        return this.isHovering(7, 97, 241, 121, x, y);
    }

    private boolean isHoveringOverRequestButtons(double x, double y) {
        int requestsInnerX = this.getRequestButtonsInnerX() - 1;
        int requestsInnerY = this.getRequestButtonsInnerY() - 1;
        return this.isHovering(requestsInnerX - this.leftPos, requestsInnerY - this.topPos, 80, 98, x, y);
    }

    private int getRequestButtonsInnerY() {
        return this.topPos + 8;
    }

    private int getRequestButtonsInnerX() {
        return this.leftPos - 83 + 4;
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected void onAmountFieldChanged() {
        if (this.amountField == null || this.confirmButton == null) {
            return;
        }
        this.disableStartButton();
        this.getAndValidateAmount().ifPresentOrElse(amount -> {
            this.confirmButton.setMessage((Component)PENDING);
            this.changedAmount = amount;
            this.amountField.setTextColor(0xFFFFFF);
        }, () -> {
            this.confirmButton.setMessage((Component)START);
            this.amountField.setTextColor(0xFF5555);
        });
    }

    private void disableStartButton() {
        if (this.confirmButton == null) {
            return;
        }
        this.confirmButton.active = false;
        this.confirmButton.setIcon(null);
        this.confirmButton.setTooltip(null);
    }

    protected void containerTick() {
        super.containerTick();
        if (this.changedAmount != null && this.requestRateLimiter.tryAcquire()) {
            ((AutocraftingPreviewContainerMenu)this.getMenu()).amountChanged(this.changedAmount);
            this.changedAmount = null;
        }
        if (this.mayEnableMaxAmountRequestButtonAgain && this.maxButton != null && this.maxAmountRequestRateLimiter.tryAcquire()) {
            this.maxButton.active = true;
            this.mayEnableMaxAmountRequestButtonAgain = false;
        }
    }

    @Override
    protected boolean beforeClose() {
        if (this.requestedCancellation) {
            return true;
        }
        this.requestedCancellation = true;
        if (this.cancelButton != null) {
            this.cancelButton.active = false;
            this.cancelButton.setMessage((Component)CANCELLING);
            this.cancelButton.setTooltip(Tooltip.create((Component)CANCELLING_FORCE_CLOSE));
        }
        ((AutocraftingPreviewContainerMenu)this.getMenu()).sendCancelRequest();
        return false;
    }

    public void cancelResponseReceived() {
        if (!this.requestedCancellation) {
            return;
        }
        this.close();
    }

    @Override
    protected void reset() {
        this.updateAmount(((AutocraftingPreviewContainerMenu)this.getMenu()).getCurrentRequest().getAmount());
    }

    @Override
    protected boolean confirm(Double amount) {
        this.disableStartButton();
        if (this.confirmButton != null) {
            this.confirmButton.setMessage((Component)PENDING);
        }
        ((AutocraftingPreviewContainerMenu)this.getMenu()).sendRequest(amount, this.notifyCheckbox == null ? ((AutocraftingPreviewContainerMenu)this.menu).isNotify() : this.notifyCheckbox.isSelected());
        return false;
    }

    @Override
    public void requestChanged(AutocraftingRequest request) {
        this.setRequest(request);
    }

    @Override
    public void previewChanged(@Nullable Preview preview, @Nullable TreePreview treePreview) {
        this.setPreview(preview, treePreview);
    }

    @Override
    public void requestRemoved(AutocraftingRequest request, boolean last) {
        if (last) {
            this.close();
            return;
        }
        this.requestButtons.stream().filter(btn -> btn.getRequest() == request).findFirst().ifPresent(btn -> {
            this.removeWidget((GuiEventListener)btn);
            this.requestButtons.remove(btn);
        });
        this.updateRequestsScrollbar();
        for (int i = 0; i < this.requestButtons.size(); ++i) {
            AutocraftingRequestButton requestButton = this.requestButtons.get(i);
            int buttonY = this.getCraftingRequestButtonY(i);
            requestButton.setY(buttonY);
            requestButton.visible = this.isCraftingRequestButtonVisible(buttonY);
        }
    }

    @Override
    public void maxAmountReceived(double maxAmount) {
        this.updateAmount(maxAmount);
        this.maxAmountRequestRateLimiter.tryAcquire();
        this.mayEnableMaxAmountRequestButtonAgain = true;
    }

    private void updateRequestsScrollbar() {
        if (this.requestButtonsScrollbar == null) {
            return;
        }
        int totalRequestButtons = ((AutocraftingPreviewContainerMenu)this.getMenu()).getRequests().size() - 4;
        int maxOffset = this.requestButtonsScrollbar.isSmoothScrolling() ? totalRequestButtons * 24 : totalRequestButtons;
        this.requestButtonsScrollbar.setEnabled(maxOffset > 0);
        this.requestButtonsScrollbar.setMaxOffset(maxOffset);
    }
}

