/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.autocrafting.PatternResolver;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

class CraftingPatternClientTooltipComponent
implements ClientTooltipComponent {
    private static final long CYCLE_MS = 1000L;
    private static final int ARROW_SPACING = 8;
    private static final ResourceLocation LARGE_SLOT = IdentifierUtil.createIdentifier("large_slot");
    private static final int LARGE_SLOT_WIDTH = 26;
    private static final int LARGE_SLOT_HEIGHT = 26;
    private final int width;
    private final int height;
    private final PatternResolver.ResolvedCraftingPattern pattern;
    @Nullable
    private final ItemStack outputStack;
    @Nullable
    private final Component outputText;
    private long cycleStart = 0L;
    private int currentCycle = 0;

    CraftingPatternClientTooltipComponent(int width, int height, PatternResolver.ResolvedCraftingPattern pattern) {
        ItemResource itemResource;
        this.width = width;
        this.height = height;
        this.pattern = pattern;
        ResourceKey resourceKey = pattern.output().resource();
        ItemResource outputResource = resourceKey instanceof ItemResource ? (itemResource = (ItemResource)resourceKey) : null;
        this.outputStack = outputResource != null ? outputResource.toItemStack(pattern.output().amount()) : null;
        this.outputText = outputResource != null ? Component.literal((String)String.format("%dx ", pattern.output().amount())).append(outputResource.toItemStack().getHoverName()).withStyle(ChatFormatting.GRAY) : null;
    }

    public int getHeight() {
        return 11 + this.height * 18 + 3;
    }

    public int getWidth(Font font) {
        return Math.max(this.outputText != null ? font.width((FormattedText)this.outputText) : 0, this.width * 18 + 8 + 22 + 8 + 26);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        long now = System.currentTimeMillis();
        if (this.cycleStart == 0L) {
            this.cycleStart = now;
        }
        if (now - this.cycleStart >= 1000L) {
            ++this.currentCycle;
            this.cycleStart = now;
        }
        if (this.outputText != null) {
            graphics.drawString(font, this.outputText, x, y, 0xAAAAAA);
        }
        this.renderInputSlots(x, y + 9 + 2, graphics);
        this.renderArrow(x, y + 9 + 2, graphics);
        this.renderResultSlot(font, x, y + 9 + 2, graphics);
    }

    private void renderInputSlots(int x, int y, GuiGraphics graphics) {
        for (int sx = 0; sx < this.width; ++sx) {
            for (int sy = 0; sy < this.height; ++sy) {
                this.renderInputSlot(x, y, graphics, sx, sy);
            }
        }
    }

    private void renderInputSlot(int x, int y, GuiGraphics graphics, int sx, int sy) {
        graphics.blitSprite(Sprites.SLOT, x + sx * 18, y + sy * 18, 18, 18);
        int index = sy * this.width + sx;
        List<ResourceKey> inputs = this.pattern.inputs().get(index);
        if (inputs.isEmpty()) {
            return;
        }
        int idx = this.currentCycle % inputs.size();
        ResourceKey resource = inputs.get(idx);
        RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass()).render(resource, graphics, x + sx * 18 + 1, y + sy * 18 + 1);
    }

    private void renderArrow(int x, int y, GuiGraphics graphics) {
        graphics.blitSprite(Sprites.LIGHT_ARROW, x + this.width * 18 + 8, y + this.height * 18 / 2 - 7, 22, 15);
    }

    private void renderResultSlot(Font font, int x, int y, GuiGraphics graphics) {
        int slotX = x + this.width * 18 + 8 + 22 + 8;
        int slotY = y + this.height * 18 / 2 - 13;
        graphics.blitSprite(LARGE_SLOT, slotX, slotY, 26, 26);
        if (this.outputStack != null) {
            int stackX = slotX + 5;
            int stackY = slotY + 5;
            graphics.renderItem(this.outputStack, stackX, stackY);
            graphics.renderItemDecorations(font, this.outputStack, stackX, stackY);
        }
    }
}

