/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node.task;

import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import java.util.List;

public class RoundRobinSchedulingMode
implements SchedulingMode {
    private final State state;

    public RoundRobinSchedulingMode(State state) {
        this.state = state;
    }

    @Override
    public void execute(List<? extends SchedulingMode.ScheduledTask> tasks) {
        int startIndex;
        if (tasks.isEmpty()) {
            return;
        }
        for (int i = startIndex = this.state.getIndex() % tasks.size(); i < tasks.size(); ++i) {
            SchedulingMode.ScheduledTask task = tasks.get(i);
            if (!task.run()) continue;
            this.state.setIndex((this.state.getIndex() + 1) % tasks.size());
            return;
        }
        this.state.setIndex(0);
    }

    public int getIndex() {
        return this.state.getIndex();
    }

    public static class State {
        private final Runnable callback;
        private int index;

        public State(Runnable callback, int index) {
            this.index = index;
            this.callback = callback;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            boolean didChange = this.index != index;
            this.index = index;
            if (didChange) {
                this.callback.run();
            }
        }
    }
}

