/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl.node;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.node.GraphNetworkComponent;
import com.refinedmods.refinedstorage.api.network.node.container.NetworkNodeContainer;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphNetworkComponentImpl
implements GraphNetworkComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphNetworkComponentImpl.class);
    private final Network network;
    private final Set<NetworkNodeContainer> containers = new HashSet<NetworkNodeContainer>();
    private final Map<Class<?>, Set<NetworkNodeContainer>> byClassIndex = new HashMap();
    private final Map<Object, NetworkNodeContainer> byKeyIndex = new HashMap<Object, NetworkNodeContainer>();

    public GraphNetworkComponentImpl(Network network) {
        this.network = network;
    }

    @Override
    public Set<NetworkNodeContainer> getContainers() {
        return Collections.unmodifiableSet(this.containers);
    }

    @Override
    public <T> Set<T> getContainers(Class<T> clazz) {
        return Collections.unmodifiableSet(this.byClassIndex.getOrDefault(clazz, Collections.emptySet()));
    }

    @Override
    @Nullable
    public NetworkNodeContainer getContainer(Object key) {
        return this.byKeyIndex.get(key);
    }

    @Override
    public void onContainerAdded(NetworkNodeContainer container) {
        LOGGER.debug("Container {} added to network {}", (Object)container, (Object)this.network.hashCode());
        this.containers.add(container);
        this.addToIndex(container);
    }

    @Override
    public void onContainerRemoved(NetworkNodeContainer container) {
        LOGGER.debug("Container {} removed from network {}", (Object)container, (Object)this.network.hashCode());
        this.containers.remove(container);
        this.removeFromIndex(container);
    }

    private void addToIndex(NetworkNodeContainer container) {
        Object key = container.createKey();
        if (key != null) {
            this.byKeyIndex.put(key, container);
        }
        Class<?> clazz = container.getClass();
        this.addToIndex(clazz, container);
        for (Class<?> iface : clazz.getInterfaces()) {
            this.addToIndex(iface, container);
        }
    }

    private void addToIndex(Class<?> indexKey, NetworkNodeContainer container) {
        this.byClassIndex.computeIfAbsent(indexKey, k -> new HashSet()).add(container);
    }

    private void removeFromIndex(NetworkNodeContainer container) {
        Object key = container.createKey();
        if (key != null) {
            this.byKeyIndex.remove(key);
        }
        Class<?> clazz = container.getClass();
        this.removeFromIndex(clazz, container);
        for (Class<?> iface : clazz.getInterfaces()) {
            this.removeFromIndex(iface, container);
        }
    }

    private void removeFromIndex(Class<?> indexKey, NetworkNodeContainer container) {
        Set<NetworkNodeContainer> index = this.byClassIndex.get(indexKey);
        if (index != null) {
            index.remove(container);
            if (index.isEmpty()) {
                this.byClassIndex.remove(indexKey);
            }
        }
    }

    @Override
    public void onNetworkRemoved() {
        LOGGER.debug("Network {} is removed", (Object)this.network.hashCode());
    }

    @Override
    public void onNetworkSplit(Set<Network> networks) {
        LOGGER.debug("Network {} has been split into {} other networks ({})", new Object[]{this.network.hashCode(), networks.size(), networks.stream().map((Function<Network, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, hashCode(), (Lcom/refinedmods/refinedstorage/api/network/Network;)Ljava/lang/Integer;)()).toList()});
    }

    @Override
    public void onNetworkMergedWith(Network newMainNetwork) {
        LOGGER.debug("Network {} has merged with network {}", (Object)newMainNetwork.hashCode(), (Object)this.network.hashCode());
    }
}

