/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopepanelcorner.CornerSlopePanelWallShapes;

public final class InverseDoubleCornerSlopePanelWallShapes
implements SplitShapeGenerator {
    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return InverseDoubleCornerSlopePanelWallShapes.generate(states, CornerSlopePanelWallShapes.SHAPES_LARGE, CornerSlopePanelWallShapes.SHAPES_SMALL_INNER);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return InverseDoubleCornerSlopePanelWallShapes.generate(states, CornerSlopePanelWallShapes.OCCLUSION_SHAPES_LARGE, CornerSlopePanelWallShapes.OCCLUSION_SHAPES_SMALL_INNER);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<HorizontalRotation> cache, ShapeCache<HorizontalRotation> innerCache) {
        HorizontalRotation rot;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        UnmodifiableIterator unmodifiableIterator = HorizontalRotation.values();
        int n = ((HorizontalRotation[])unmodifiableIterator).length;
        for (int i = 0; i < n; ++i) {
            HorizontalRotation backRot = rot.rotate((rot = unmodifiableIterator[i]).isVertical() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
            VoxelShape preShape = ShapeUtils.orUnoptimized(cache.get(rot), ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.SOUTH, innerCache.get(backRot)));
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int idx = dir.get2DDataValue() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

