/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.cube;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;

public final class LayeredCubeShapes {
    private static final int LAYER_COUNT = 8;
    private static final int DIR_COUNT = Direction.values().length;

    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        VoxelShape[] shapes = new VoxelShape[8 * DIR_COUNT];
        for (int i = 1; i <= 8; ++i) {
            VoxelShape layerShapeUp = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(i * 2), (double)16.0);
            VoxelShape layerShapeDown = ShapeUtils.rotateShapeAroundX(Direction.UP, Direction.DOWN, layerShapeUp);
            VoxelShape layerShapeNorth = ShapeUtils.rotateShapeAroundX(Direction.UP, Direction.NORTH, layerShapeUp);
            shapes[LayeredCubeShapes.index((Direction)Direction.UP, (int)i)] = layerShapeUp;
            shapes[LayeredCubeShapes.index((Direction)Direction.DOWN, (int)i)] = layerShapeDown;
            ShapeUtils.makeHorizontalRotations(layerShapeNorth, Direction.NORTH, shapes, LayeredCubeShapes.index(Direction.NORTH, i));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            int layers = (Integer)state.getValue((Property)BlockStateProperties.LAYERS);
            builder.put((Object)state, (Object)shapes[LayeredCubeShapes.index(dir, layers)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static int index(Direction dir, int layers) {
        return (layers - 1) * DIR_COUNT + dir.ordinal();
    }

    private LayeredCubeShapes() {
    }
}

