/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.standard;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;

public class FramedDoubleHalfStairsBlock
extends AbstractFramedDoubleBlock {
    public FramedDoubleHalfStairsBlock() {
        super(BlockType.FRAMED_DOUBLE_HALF_STAIRS);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, PropertyHolder.RIGHT, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withTargetOrHorizontalFacing()).withTop()).withRight().withWater()).build();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot == Rotation.NONE) {
            return state;
        }
        if (face.getAxis() == dir.getAxis()) {
            return (BlockState)state.cycle((Property)PropertyHolder.RIGHT);
        }
        return (BlockState)state.cycle((Property)FramedProperties.TOP);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (mirror == Mirror.FRONT_BACK && Utils.isX(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isZ(dir)) {
            state = (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite());
        }
        return (BlockState)state.cycle((Property)PropertyHolder.RIGHT);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        if (((Boolean)state.getValue((Property)FramedProperties.TOP)).booleanValue()) {
            return DoubleBlockTopInteractionMode.FIRST;
        }
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
        boolean right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(right))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)(right ? dir.getOpposite() : dir.getCounterClockWise()))).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top))));
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT);
        if (!right && side == dir.getCounterClockWise() || right && side == dir.getClockWise()) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirThree;
        if (edge == null) {
            return CamoGetter.NONE;
        }
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
        boolean right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT);
        Direction dirTwo = top ? Direction.UP : Direction.DOWN;
        Direction direction = dirThree = right ? dir.getClockWise() : dir.getCounterClockWise();
        if ((side == dir || side == dirTwo) && edge == dirThree) {
            return CamoGetter.FIRST;
        }
        if (side == dirThree && (edge == dir || edge == dirTwo)) {
            return CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH)).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

