/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanelcorner;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelGeometry;

public class FramedExtendedCornerSlopePanelGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;
    private final boolean ySlope;

    public FramedExtendedCornerSlopePanelGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir == this.dir || quadDir == this.dir.getCounterClockWise()) {
            Direction cutDir = quadDir == this.dir ? this.dir.getClockWise() : this.dir.getOpposite();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, this.top ? 1.0f : 0.5f, this.top ? 0.5f : 1.0f)).export(quadMap.get(quadDir));
        } else if (!(this.ySlope || quadDir != this.dir.getOpposite() && quadDir != this.dir.getClockWise())) {
            Direction cutDir = quadDir == this.dir.getOpposite() ? this.dir.getClockWise() : this.dir.getOpposite();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, this.top ? 1.0f : 0.5f, this.top ? 0.5f : 1.0f)).apply(Modifiers.makeVerticalSlope(!this.top, FramedSlopePanelGeometry.SLOPE_ANGLE)).export(quadMap.get(null));
        } else if (!this.top && quadDir == Direction.UP || this.top && quadDir == Direction.DOWN) {
            if (this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f, 1.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getClockWise(), FramedSlopePanelGeometry.SLOPE_ANGLE_VERT)).apply(Modifiers.offset(this.dir.getClockWise(), 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 1.0f, 0.5f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), FramedSlopePanelGeometry.SLOPE_ANGLE_VERT)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
            }
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f)).export(quadMap.get(quadDir));
        }
    }
}

