/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;

public class FramedLayeredCubeGeometry
extends Geometry {
    private static final ItemModelInfo ITEM_MODEL_INFO = TranslatedItemModelInfo.hand(0.0f, 0.8f, 0.0f);
    private static final float LAYER_HEIGHT = 0.125f;
    private final Direction facing;
    private final float height;

    public FramedLayeredCubeGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)BlockStateProperties.FACING);
        this.height = (float)((Integer)ctx.state().getValue((Property)BlockStateProperties.LAYERS)).intValue() * 0.125f;
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir == this.facing) {
            QuadModifier.of(quad).apply(Modifiers.setPosition(this.height)).export(quadMap.get(null));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cut(this.facing, this.height)).export(quadMap.get(quadDir));
        }
    }

    @Override
    public boolean useBaseModel() {
        return true;
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return ITEM_MODEL_INFO;
    }
}

