/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util.citizenutils;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.network.messages.client.BlockParticleEffectMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenItemUtils {
    public static void tryPickupItemEntity(@NotNull AbstractEntityCitizen citizen, @NotNull ItemEntity itemEntity) {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)citizen).isClientSide) {
            if (itemEntity.hasPickUpDelay()) {
                return;
            }
            ItemStack itemStack = itemEntity.getItem();
            ItemStack compareStack = itemStack.copy();
            if (citizen.getCitizenJobHandler().getColonyJob() == null || citizen.getCitizenJobHandler().getColonyJob().pickupSuccess(compareStack)) {
                int resultingStackSize;
                ItemStack resultStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)citizen.getInventoryCitizen(), itemStack);
                int n = resultingStackSize = ItemStackUtils.isEmpty(resultStack) ? 0 : ItemStackUtils.getSize(resultStack);
                if (ItemStackUtils.isEmpty(resultStack) || ItemStackUtils.getSize(resultStack) != ItemStackUtils.getSize(compareStack)) {
                    CompatibilityUtils.getWorldFromCitizen(citizen).playSound(null, citizen.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.AMBIENT, 0.2f, (float)((citizen.getRandom().nextGaussian() * 0.7 + 1.0) * 2.0));
                    citizen.take((Entity)itemEntity, ItemStackUtils.getSize(itemStack) - resultingStackSize);
                    ItemStack overrulingStack = itemStack.copy();
                    overrulingStack.setCount(ItemStackUtils.getSize(itemStack) - resultingStackSize);
                    if (citizen.getCitizenJobHandler().getColonyJob() != null) {
                        citizen.getCitizenJobHandler().getColonyJob().onStackPickUp(overrulingStack);
                    }
                    if (ItemStackUtils.isEmpty(resultStack)) {
                        itemEntity.remove(Entity.RemovalReason.DISCARDED);
                    }
                }
            } else {
                itemEntity.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public static void removeHeldItem(AbstractEntityCitizen citizen) {
        citizen.setItemSlot(EquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
    }

    public static void setHeldItem(@NotNull AbstractEntityCitizen citizen, InteractionHand hand, int slot) {
        citizen.getCitizenData().getInventory().setHeldItem(hand, slot);
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            citizen.setItemSlot(EquipmentSlot.MAINHAND, citizen.getCitizenData().getInventory().getStackInSlot(slot));
        } else if (hand.equals((Object)InteractionHand.OFF_HAND)) {
            citizen.setItemSlot(EquipmentSlot.OFFHAND, citizen.getCitizenData().getInventory().getStackInSlot(slot));
        }
    }

    public static void setMainHeldItem(@NotNull AbstractEntityCitizen citizen, int slot) {
        citizen.getCitizenData().getInventory().setHeldItem(InteractionHand.MAIN_HAND, slot);
        citizen.setItemSlot(EquipmentSlot.MAINHAND, citizen.getCitizenData().getInventory().getStackInSlot(slot));
    }

    public static void hitBlockWithToolInHand(@NotNull AbstractEntityCitizen citizen, @Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        CitizenItemUtils.hitBlockWithToolInHand(citizen, blockPos, false);
    }

    public static void hitBlockWithToolInHand(@NotNull AbstractEntityCitizen citizen, @Nullable BlockPos blockPos, boolean breakBlock) {
        if (blockPos == null) {
            return;
        }
        citizen.getLookControl().setLookAt((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 10.0f, (float)citizen.getMaxHeadXRot());
        citizen.swing(citizen.getUsedItemHand());
        BlockState blockState = CompatibilityUtils.getWorldFromCitizen(citizen).getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (breakBlock) {
            if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)citizen).isClientSide) {
                new BlockParticleEffectMessage(blockPos, CompatibilityUtils.getWorldFromCitizen(citizen).getBlockState(blockPos), -1).sendToTargetPoint((ServerLevel)citizen.level(), null, blockPos.getX(), blockPos.getY(), blockPos.getZ(), 16.0);
            }
            CompatibilityUtils.getWorldFromCitizen(citizen).playSound(null, blockPos, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).getBreakSound(), SoundSource.BLOCKS, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).getVolume(), block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).getPitch());
            WorldUtil.removeBlock((LevelAccessor)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, false);
            CitizenItemUtils.damageItemInHand(citizen, citizen.getUsedItemHand(), 1);
        } else {
            if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)citizen).isClientSide) {
                BlockPos vector = blockPos.subtract((Vec3i)citizen.blockPosition());
                Direction facing = BlockPosUtil.directionFromDelta(vector.getX(), vector.getY(), vector.getZ()).getOpposite();
                new BlockParticleEffectMessage(blockPos, CompatibilityUtils.getWorldFromCitizen(citizen).getBlockState(blockPos), facing.ordinal()).sendToTargetPoint((ServerLevel)citizen.level(), null, blockPos.getX(), blockPos.getY(), blockPos.getZ(), 16.0);
            }
            CompatibilityUtils.getWorldFromCitizen(citizen).playSound(null, blockPos, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).getBreakSound(), SoundSource.BLOCKS, block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).getVolume(), block.getSoundType(blockState, (LevelReader)CompatibilityUtils.getWorldFromCitizen(citizen), blockPos, (Entity)citizen).getPitch());
        }
    }

    public static void damageItemInHand(@NotNull AbstractEntityCitizen citizen, InteractionHand hand, int damage) {
        ItemStack heldItem = citizen.getCitizenData().getInventory().getHeldItem(hand);
        if (heldItem == null || heldItem.isEmpty()) {
            return;
        }
        if (citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TOOL_DURABILITY) > 0.0 && citizen.getRandom().nextDouble() > 1.0 / (1.0 + citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TOOL_DURABILITY))) {
            return;
        }
        if (citizen.getCitizenData().getInventory().damageInventoryItem(citizen.getCitizenData().getInventory().getHeldItemSlot(hand), damage, citizen, item -> {})) {
            if (hand == InteractionHand.MAIN_HAND) {
                citizen.setItemSlot(EquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
            } else {
                citizen.setItemSlot(EquipmentSlot.OFFHAND, ItemStackUtils.EMPTY);
            }
        }
    }

    public static void pickupItems(AbstractEntityCitizen citizen) {
        for (ItemEntity item : CompatibilityUtils.getWorldFromCitizen(citizen).getEntitiesOfClass(ItemEntity.class, new AABB(citizen.blockPosition()).expandTowards(2.0, 1.0, 2.0).expandTowards(-2.0, -1.0, -2.0))) {
            if (item == null || !item.isAlive()) continue;
            CitizenItemUtils.tryPickupItemEntity(citizen, item);
        }
    }

    public static void breakBlockWithToolInHand(@NotNull AbstractEntityCitizen citizen, @Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        CitizenItemUtils.hitBlockWithToolInHand(citizen, blockPos, true);
    }

    public static ItemEntity entityDropItem(@NotNull AbstractEntityCitizen citizen, @NotNull ItemStack itemstack) {
        return citizen.spawnAtLocation(itemstack, 0.0f);
    }

    public static void updateArmorDamage(@NotNull AbstractEntityCitizen citizen, double damage) {
        if (citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARMOR_DURABILITY) > 0.0 && citizen.getRandom().nextDouble() > 1.0 / (1.0 + citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARMOR_DURABILITY))) {
            return;
        }
        int armorDmg = Math.max(1, (int)(damage / 4.0));
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack equipment = citizen.getInventoryCitizen().getArmorInSlot(equipmentSlot);
            equipment.hurtAndBreak(armorDmg, (ServerLevel)citizen.level(), (LivingEntity)citizen, s -> {
                citizen.onArmorRemove(equipment, equipmentSlot);
                citizen.getInventoryCitizen().markDirty();
            });
        }
    }

    public static double applyMending(@NotNull AbstractEntityCitizen citizen, double xp) {
        double localXp = xp;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (localXp <= 0.0) break;
            ItemStack tool = equipmentSlot.isArmor() ? citizen.getInventoryCitizen().getArmorInSlot(equipmentSlot) : citizen.getInventoryCitizen().getHeldItem(equipmentSlot == EquipmentSlot.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            if (ItemStackUtils.isEmpty(tool) || !tool.isDamaged() || !tool.isEnchanted() || EnchantmentHelper.getTagEnchantmentLevel(Utils.getRegistryValue(Enchantments.MENDING, citizen.level()), (ItemStack)tool) <= 0) continue;
            double dmgHealed = Math.min(localXp / 2.0, (double)tool.getDamageValue());
            localXp -= dmgHealed * 2.0;
            tool.setDamageValue(tool.getDamageValue() - (int)Math.ceil(dmgHealed));
        }
        return localXp;
    }
}

