/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.claim.IChunkClaimData;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.Colony;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public final class ChunkDataHelper {
    private ChunkDataHelper() {
    }

    public static void loadChunk(LevelChunk chunk, ServerLevel world) {
        IColony colony;
        int closeColony = ColonyUtils.getOwningColony((ChunkAccess)chunk);
        if (closeColony != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeColony, (ResourceKey<Level>)world.dimension())) != null) {
            colony.addLoadedChunk(ChunkPos.asLong((int)chunk.getPos().x, (int)chunk.getPos().z), chunk);
        }
    }

    public static void unloadChunk(LevelChunk chunk, Level world) {
        IColony colony;
        int closeColony = ColonyUtils.getOwningColony((ChunkAccess)chunk);
        if (closeColony != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(closeColony, (ResourceKey<Level>)world.dimension())) != null) {
            colony.removeLoadedChunk(ChunkPos.asLong((int)chunk.getPos().x, (int)chunk.getPos().z));
        }
    }

    public static void claimColonyChunks(ServerLevel world, boolean add, Colony colony, BlockPos center) {
        int range = (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).initialColonySize.get();
        ChunkDataHelper.staticClaimInRange(colony, add, center, add ? range : range * 2, world, false);
    }

    public static void claimBuildingChunks(Colony colony, boolean add, BlockPos center, int range, @Nullable Tuple<BlockPos, BlockPos> corners) {
        ChunkDataHelper.buildingClaimInRange(colony, add, range, center, false);
        if (corners != null) {
            ChunkDataHelper.buildingClaimBox(colony, center, add, corners);
        }
    }

    public static boolean canClaimChunksInRange(Level w, BlockPos pos, int range) {
        LevelChunk centralChunk = w.getChunkAt(pos);
        int chunkX = centralChunk.getPos().x;
        int chunkZ = centralChunk.getPos().z;
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                LevelChunk chunk = w.getChunk(i, j);
                IChunkClaimData colonyCap = IColonyManager.getInstance().getClaimData((ResourceKey<Level>)w.dimension(), chunk.getPos());
                if (colonyCap == null) {
                    return true;
                }
                if (colonyCap.getOwningColony() == 0) continue;
                return false;
            }
        }
        return true;
    }

    private static void buildingClaimInRange(Colony colony, boolean add, int range, BlockPos center, boolean force) {
        ServerLevel world = colony.getWorld();
        BlockPos colonyCenterCompare = new BlockPos(colony.getCenter().getX(), 0, colony.getCenter().getZ());
        ChunkPos colonyCenterChunk = new ChunkPos(colonyCenterCompare);
        int chunkX = center.getX() >> 4;
        int chunkZ = center.getZ() >> 4;
        int maxColonySize = (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxColonySize.get();
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                ChunkPos chunkPos = new ChunkPos(i, j);
                BlockPos pos = chunkPos.getWorldPosition();
                if (!force && maxColonySize != 0 && chunkPos.distanceSquared(colonyCenterChunk) > maxColonySize * maxColonySize) {
                    Log.getLogger().debug("Tried to claim chunk at pos X:" + pos.getX() + " Z:" + pos.getZ() + " too far away from the colony:" + colony.getID() + " center:" + String.valueOf(colony.getCenter()) + " max is config workingRangeTownHall ^2");
                    continue;
                }
                if (!ChunkDataHelper.tryClaimBuilding(world, chunkPos, add, colony, center)) continue;
            }
        }
        if (add && range > 0) {
            IBuilding building = colony.getBuildingManager().getBuilding(center);
            MessageUtils.format("com.minecolonies.coremod.colonysizechange", range, building.getSchematicName()).sendTo(colony).forManagers();
        }
    }

    private static void buildingClaimBox(Colony colony, BlockPos anchor, boolean add, Tuple<BlockPos, BlockPos> corners) {
        ServerLevel world = colony.getWorld();
        int maxColonySize = (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxColonySize.get();
        BlockPos colonyCenterCompare = new BlockPos(colony.getCenter().getX(), 0, colony.getCenter().getZ());
        for (ChunkPos chunk : ChunkPos.rangeClosed((ChunkPos)new ChunkPos((BlockPos)corners.getA()), (ChunkPos)new ChunkPos((BlockPos)corners.getB())).toList()) {
            BlockPos pos = chunk.getWorldPosition();
            if (maxColonySize != 0 && pos.distSqr((Vec3i)colonyCenterCompare) > Math.pow(maxColonySize * 16, 2.0)) {
                Log.getLogger().debug("Tried to claim chunk at pos X:" + pos.getX() + " Z:" + pos.getZ() + " too far away from the colony:" + colony.getID() + " center:" + String.valueOf(colony.getCenter()) + " max is config workingRangeTownHall ^2");
                continue;
            }
            ChunkDataHelper.tryClaimBuilding(world, chunk, add, colony, anchor);
        }
    }

    public static void staticClaimInRange(Colony colony, boolean add, BlockPos center, int range, ServerLevel world, boolean forceOwnerChange) {
        LevelChunk centralChunk = world.getChunkAt(center);
        int chunkXMax = centralChunk.getPos().x;
        int chunkZMax = centralChunk.getPos().z;
        for (int chunkPosX = chunkXMax - range; chunkPosX <= chunkXMax + range; ++chunkPosX) {
            for (int chunkPosZ = chunkZMax - range; chunkPosZ <= chunkZMax + range; ++chunkPosZ) {
                ChunkDataHelper.tryClaim(world, new BlockPos(chunkPosX * 16, 0, chunkPosZ * 16), add, colony, forceOwnerChange);
            }
        }
    }

    public static boolean tryClaim(ServerLevel world, BlockPos chunkBlockPos, boolean add, Colony colony, boolean forceOwnerChange) {
        LevelChunk chunk = (LevelChunk)world.getChunk(chunkBlockPos);
        IChunkClaimData chunkClaimData = IColonyManager.getInstance().getClaimData((ResourceKey<Level>)world.dimension(), chunk.getPos());
        int id = colony.getID();
        if (chunkClaimData == null) {
            if (add) {
                chunkClaimData = colony.claimNewChunk(chunk.getPos());
            } else {
                return true;
            }
        }
        if (add) {
            chunkClaimData.addColony(id, chunk);
            if (forceOwnerChange) {
                chunkClaimData.setOwningColony(id, chunk);
                colony.addLoadedChunk(ChunkPos.asLong((int)chunk.getPos().x, (int)chunk.getPos().z), chunk);
            }
        } else {
            chunkClaimData.removeColony(id, chunk);
        }
        return true;
    }

    public static boolean tryClaimBuilding(ServerLevel world, ChunkPos chunkBlockPos, boolean add, Colony colony, BlockPos buildingPos) {
        LevelChunk chunk = world.getChunk(chunkBlockPos.x, chunkBlockPos.z);
        IChunkClaimData chunkClaimData = IColonyManager.getInstance().getClaimData((ResourceKey<Level>)world.dimension(), chunk.getPos());
        if (chunkClaimData == null) {
            if (add) {
                chunkClaimData = colony.claimNewChunk(chunk.getPos());
            } else {
                return false;
            }
        }
        if (chunk.getPos().equals((Object)ChunkPos.ZERO) && chunk.getPos().equals((Object)ChunkPos.ZERO) && (colony == null || BlockPosUtil.getDistance2D(colony.getCenter(), BlockPos.ZERO) > 200L)) {
            Log.getLogger().warn("Trying to claim at zero chunk pos!:", (Throwable)new Exception());
        }
        if (add) {
            chunkClaimData.addBuildingClaim(colony.getID(), buildingPos, chunk);
        } else {
            chunkClaimData.removeBuildingClaim(colony.getID(), buildingPos, chunk);
        }
        return true;
    }
}

