/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class ResearchEffectCategory {
    private final ResourceLocation effectId;
    private final String effectName;
    private final String subtitle;
    private final List<Double> levelsAbsolute = new ArrayList<Double>();
    private final List<Double> levelsRelative = new ArrayList<Double>();

    public ResearchEffectCategory(ResourceLocation effectId, String effectName, String subtitle, List<Double> levels) {
        this.effectId = effectId;
        this.effectName = effectName;
        this.subtitle = subtitle;
        this.levelsAbsolute.add(0.0);
        this.levelsRelative.add(0.0);
        levels.forEach(level -> {
            this.levelsRelative.add(level - this.levelsAbsolute.getLast());
            this.levelsAbsolute.add((Double)level);
        });
    }

    public double getDisplay(int level) {
        return this.levelsRelative.get(level);
    }

    public double get(int level) {
        return this.levelsAbsolute.get(level);
    }

    public int getMaxLevel() {
        return this.levelsAbsolute.size() - 1;
    }

    public ResourceLocation getId() {
        return this.effectId;
    }

    public String getName() {
        return this.effectName;
    }

    public String getSubtitle() {
        return this.subtitle;
    }
}

